/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Base10;
import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Writer;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.header.MaxForwardsParser;
import swim.util.Murmur3;

public final class MaxForwards
extends HttpHeader {
    private static int hashSeed;
    final int count;

    MaxForwards(int count) {
        this.count = count;
    }

    public static MaxForwards from(int count) {
        if (count < 0) {
            throw new IllegalArgumentException(Integer.toString(count));
        }
        return new MaxForwards(count);
    }

    public static Parser<MaxForwards> parseHttpValue(Input input, HttpParser http) {
        return MaxForwardsParser.parse(input);
    }

    @Override
    public String lowerCaseName() {
        return "max-forwards";
    }

    @Override
    public String name() {
        return "Max-Forwards";
    }

    public int count() {
        return this.count;
    }

    @Override
    public Writer<?, ?> writeHttpValue(Output<?> output, HttpWriter http) {
        return Base10.writeInt((int)this.count, output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MaxForwards) {
            MaxForwards that = (MaxForwards)other;
            return this.count == that.count;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(MaxForwards.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.count));
    }

    public void debug(Output<?> output) {
        output = output.write("MaxForwards").write(46).write("from").write(40).debug((Object)this.count).write(41);
    }
}

