/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.collections.FingerTrieSeq;
import swim.http.header.Origin;
import swim.uri.Uri;
import swim.uri.UriAuthority;
import swim.uri.UriHost;
import swim.uri.UriPort;
import swim.uri.UriScheme;
import swim.util.Builder;

final class OriginParser
extends Parser<Origin> {
    final Parser<UriScheme> scheme;
    final Parser<UriHost> host;
    final Parser<UriPort> port;
    final Builder<Uri, FingerTrieSeq<Uri>> origins;
    final int step;

    OriginParser(Parser<UriScheme> scheme, Parser<UriHost> host, Parser<UriPort> port, Builder<Uri, FingerTrieSeq<Uri>> origins, int step) {
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.origins = origins;
        this.step = step;
    }

    OriginParser() {
        this(null, null, null, null, 1);
    }

    static Parser<Origin> parse(Input input, Parser<UriScheme> scheme, Parser<UriHost> host, Parser<UriPort> port, Builder<Uri, FingerTrieSeq<Uri>> origins, int step) {
        block32: {
            while (true) {
                if (step == 1) {
                    if ((scheme = scheme == null ? Uri.standardParser().parseScheme(input) : scheme.feed(input)).isDone()) {
                        if (input.isCont() && input.head() == 58) {
                            input = input.step();
                            step = 2;
                        } else if (!input.isEmpty()) {
                            if (origins == null && "null".equals(((UriScheme)scheme.bind()).name())) {
                                return OriginParser.done((Object)Origin.empty());
                            }
                            return OriginParser.error((Diagnostic)Diagnostic.expected((int)58, (Input)input));
                        }
                    } else if (scheme.isError()) {
                        return scheme.asError();
                    }
                }
                if (step == 2) {
                    if (input.isCont() && input.head() == 47) {
                        input = input.step();
                        step = 3;
                    } else if (!input.isEmpty()) {
                        return OriginParser.error((Diagnostic)Diagnostic.expected((int)47, (Input)input));
                    }
                }
                if (step == 3) {
                    if (input.isCont() && input.head() == 47) {
                        input = input.step();
                        step = 4;
                    } else if (!input.isEmpty()) {
                        return OriginParser.error((Diagnostic)Diagnostic.expected((int)47, (Input)input));
                    }
                }
                if (step == 4) {
                    if ((host = host == null ? Uri.standardParser().parseHost(input) : host.feed(input)).isDone()) {
                        if (input.isCont() && input.head() == 58) {
                            input = input.step();
                            step = 5;
                        } else if (!input.isEmpty()) {
                            if (origins == null) {
                                origins = FingerTrieSeq.builder();
                            }
                            origins.add((Object)Uri.from((UriScheme)((UriScheme)scheme.bind()), (UriAuthority)UriAuthority.from((UriHost)((UriHost)host.bind()))));
                            scheme = null;
                            host = null;
                            step = 6;
                        }
                    } else if (host.isError()) {
                        return host.asError();
                    }
                }
                if (step == 5) {
                    if ((port = port == null ? Uri.standardParser().parsePort(input) : port.feed(input)).isDone()) {
                        if (origins == null) {
                            origins = FingerTrieSeq.builder();
                        }
                        origins.add((Object)Uri.from((UriScheme)((UriScheme)scheme.bind()), (UriAuthority)UriAuthority.from((UriHost)((UriHost)host.bind()), (UriPort)((UriPort)port.bind()))));
                        scheme = null;
                        host = null;
                        port = null;
                        step = 6;
                    } else if (port.isError()) {
                        return port.asError();
                    }
                }
                if (step != 6) break block32;
                if (!input.isCont() || input.head() != 32) break;
                input = input.step();
                step = 1;
            }
            if (!input.isEmpty()) {
                return OriginParser.done((Object)Origin.from((FingerTrieSeq<Uri>)((FingerTrieSeq)origins.bind())));
            }
        }
        if (input.isError()) {
            return OriginParser.error((Throwable)input.trap());
        }
        return new OriginParser((Parser<UriScheme>)scheme, (Parser<UriHost>)host, (Parser<UriPort>)port, (Builder<Uri, FingerTrieSeq<Uri>>)origins, step);
    }

    static Parser<Origin> parse(Input input) {
        return OriginParser.parse(input, null, null, null, null, 1);
    }

    public Parser<Origin> feed(Input input) {
        return OriginParser.parse(input, this.scheme, this.host, this.port, this.origins, this.step);
    }
}

