/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Utf8;
import swim.http.Http;
import swim.http.header.RawHeader;

final class RawHeaderParser
extends Parser<RawHeader> {
    final String lowerCaseName;
    final String name;
    final Output<String> value;
    final int step;

    RawHeaderParser(String lowerCaseName, String name, Output<String> value, int step) {
        this.lowerCaseName = lowerCaseName;
        this.name = name;
        this.value = value;
        this.step = step;
    }

    RawHeaderParser(String lowerCaseName, String name) {
        this(lowerCaseName, name, null, 1);
    }

    static Parser<RawHeader> parse(Input input, String lowerCaseName, String name, Output<String> value, int step) {
        block10: {
            int c = 0;
            while (true) {
                if (step == 1) {
                    if (value == null) {
                        value = Utf8.decodedString();
                    }
                    while (input.isCont() && Http.isFieldChar(c = input.head())) {
                        input = input.step();
                        value.write(c);
                    }
                    if (input.isCont() && Http.isSpace(c)) {
                        input = input.step();
                        step = 2;
                    } else if (!input.isEmpty()) {
                        return RawHeaderParser.done((Object)RawHeader.from(lowerCaseName, name, (String)value.bind()));
                    }
                }
                if (step != 2) break block10;
                while (input.isCont() && Http.isSpace(c = input.head())) {
                    input = input.step();
                }
                if (!input.isCont() || !Http.isFieldChar(c)) break;
                input = input.step();
                value.write(32);
                value.write(c);
                step = 1;
            }
            if (!input.isEmpty()) {
                return RawHeaderParser.done((Object)RawHeader.from(lowerCaseName, name, (String)value.bind()));
            }
        }
        if (input.isError()) {
            return RawHeaderParser.error((Throwable)input.trap());
        }
        return new RawHeaderParser(lowerCaseName, name, (Output<String>)value, step);
    }

    static Parser<RawHeader> parse(Input input, String lowerCaseName, String name) {
        return RawHeaderParser.parse(input, lowerCaseName, name, null, 1);
    }

    public Parser<RawHeader> feed(Input input) {
        return RawHeaderParser.parse(input, this.lowerCaseName, this.name, this.value, this.step);
    }
}

