/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Base64;
import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.http.header.SecWebSocketAccept;

final class SecWebSocketAcceptParser
extends Parser<SecWebSocketAccept> {
    final Parser<byte[]> digest;

    SecWebSocketAcceptParser(Parser<byte[]> digest) {
        this.digest = digest;
    }

    SecWebSocketAcceptParser() {
        this(null);
    }

    static Parser<SecWebSocketAccept> parse(Input input, Parser<byte[]> digest) {
        if ((digest = digest == null ? Base64.standard().parseByteArray(input) : digest.feed(input)).isDone()) {
            byte[] data = (byte[])digest.bind();
            if (data.length != 0) {
                return SecWebSocketAcceptParser.done((Object)SecWebSocketAccept.from(data));
            }
            return SecWebSocketAcceptParser.error((Diagnostic)Diagnostic.expected((String)"base64 digest", (Input)input));
        }
        if (digest.isError()) {
            return digest.asError();
        }
        if (input.isError()) {
            return SecWebSocketAcceptParser.error((Throwable)input.trap());
        }
        return new SecWebSocketAcceptParser((Parser<byte[]>)digest);
    }

    static Parser<SecWebSocketAccept> parse(Input input) {
        return SecWebSocketAcceptParser.parse(input, null);
    }

    public Parser<SecWebSocketAccept> feed(Input input) {
        return SecWebSocketAcceptParser.parse(input, this.digest);
    }
}

