/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import swim.codec.Base64;
import swim.codec.Binary;
import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Unicode;
import swim.codec.Writer;
import swim.http.HttpException;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.header.SecWebSocketAccept;
import swim.http.header.SecWebSocketKeyParser;
import swim.util.Murmur3;

public final class SecWebSocketKey
extends HttpHeader {
    private static int hashSeed;
    final byte[] key;

    SecWebSocketKey(byte[] key) {
        this.key = key;
    }

    public static SecWebSocketKey from(byte[] key) {
        return new SecWebSocketKey(key);
    }

    public static SecWebSocketKey from(String keyString) {
        Input input = Unicode.stringInput((String)keyString);
        Parser parser = Base64.standard().parseByteArray(input);
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        }
        return new SecWebSocketKey((byte[])parser.bind());
    }

    public static SecWebSocketKey generate() {
        byte[] key = new byte[16];
        ThreadLocalRandom.current().nextBytes(key);
        return new SecWebSocketKey(key);
    }

    public static Parser<SecWebSocketKey> parseHttpValue(Input input, HttpParser http) {
        return SecWebSocketKeyParser.parse(input);
    }

    @Override
    public String lowerCaseName() {
        return "sec-websocket-key";
    }

    @Override
    public String name() {
        return "Sec-WebSocket-Key";
    }

    public byte[] key() {
        return this.key;
    }

    public SecWebSocketAccept accept() {
        Output output = Binary.byteArrayOutput((int)60);
        Base64.standard().writeByteArray(this.key, output);
        String seed = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
        int n = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11".length();
        for (int i = 0; i < n; ++i) {
            output = output.write((int)((byte)"258EAFA5-E914-47DA-95CA-C5AB0DC85B11".charAt(i)));
        }
        try {
            byte[] digest = MessageDigest.getInstance("SHA-1").digest((byte[])output.bind());
            return new SecWebSocketAccept(digest);
        }
        catch (NoSuchAlgorithmException cause) {
            throw new HttpException(cause);
        }
    }

    @Override
    public Writer<?, ?> writeHttpValue(Output<?> output, HttpWriter http) {
        return Base64.standard().writeByteArray(this.key, output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof SecWebSocketKey) {
            SecWebSocketKey that = (SecWebSocketKey)other;
            return Arrays.equals(this.key, that.key);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(SecWebSocketKey.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)Arrays.hashCode(this.key)));
    }

    public void debug(Output<?> output) {
        output = output.write("SecWebSocketKey").write(46).write("from").write(40).write(34);
        Base64.standard().writeByteArray(this.key, output);
        output = output.write(34).write(41);
    }
}

