/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.collections.FingerTrieSeq;
import swim.http.HttpParser;
import swim.http.header.SecWebSocketProtocol;

final class SecWebSocketProtocolParser
extends Parser<SecWebSocketProtocol> {
    final HttpParser http;
    final Parser<FingerTrieSeq<String>> protocols;

    SecWebSocketProtocolParser(HttpParser http, Parser<FingerTrieSeq<String>> protocols) {
        this.http = http;
        this.protocols = protocols;
    }

    SecWebSocketProtocolParser(HttpParser http) {
        this(http, null);
    }

    static Parser<SecWebSocketProtocol> parse(Input input, HttpParser http, Parser<FingerTrieSeq<String>> protocols) {
        if ((protocols = protocols == null ? http.parseTokenList(input) : protocols.feed(input)).isDone()) {
            FingerTrieSeq tokens = (FingerTrieSeq)protocols.bind();
            if (!tokens.isEmpty()) {
                return SecWebSocketProtocolParser.done((Object)SecWebSocketProtocol.from((FingerTrieSeq<String>)tokens));
            }
            return SecWebSocketProtocolParser.error((Diagnostic)Diagnostic.expected((String)"websocket protocol", (Input)input));
        }
        if (protocols.isError()) {
            return protocols.asError();
        }
        if (input.isError()) {
            return SecWebSocketProtocolParser.error((Throwable)input.trap());
        }
        return new SecWebSocketProtocolParser(http, (Parser<FingerTrieSeq<String>>)protocols);
    }

    static Parser<SecWebSocketProtocol> parse(Input input, HttpParser http) {
        return SecWebSocketProtocolParser.parse(input, http, null);
    }

    public Parser<SecWebSocketProtocol> feed(Input input) {
        return SecWebSocketProtocolParser.parse(input, this.http, this.protocols);
    }
}

