/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Writer;
import swim.collections.FingerTrieSeq;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.header.SecWebSocketVersionParser;
import swim.util.Murmur3;

public final class SecWebSocketVersion
extends HttpHeader {
    private static int hashSeed;
    private static SecWebSocketVersion version13;
    final FingerTrieSeq<Integer> versions;

    SecWebSocketVersion(FingerTrieSeq<Integer> versions) {
        this.versions = versions;
    }

    public static SecWebSocketVersion version13() {
        if (version13 == null) {
            version13 = new SecWebSocketVersion((FingerTrieSeq<Integer>)FingerTrieSeq.of((Object[])new Integer[]{13}));
        }
        return version13;
    }

    public static SecWebSocketVersion from(FingerTrieSeq<Integer> versions) {
        int version;
        if (versions.size() == 1 && (version = ((Integer)versions.head()).intValue()) == 13) {
            return SecWebSocketVersion.version13();
        }
        return new SecWebSocketVersion(versions);
    }

    public static SecWebSocketVersion from(Integer ... versions) {
        int version;
        if (versions.length == 1 && (version = versions[0].intValue()) == 13) {
            return SecWebSocketVersion.version13();
        }
        return new SecWebSocketVersion((FingerTrieSeq<Integer>)FingerTrieSeq.of((Object[])versions));
    }

    public static Parser<SecWebSocketVersion> parseHttpValue(Input input, HttpParser http) {
        return SecWebSocketVersionParser.parse(input);
    }

    @Override
    public boolean isBlank() {
        return this.versions.isEmpty();
    }

    @Override
    public String lowerCaseName() {
        return "sec-websocket-version";
    }

    @Override
    public String name() {
        return "Sec-WebSocket-Version";
    }

    public FingerTrieSeq<Integer> versions() {
        return this.versions;
    }

    public boolean supports(int version) {
        return this.versions.contains((Object)version);
    }

    @Override
    public Writer<?, ?> writeHttpValue(Output<?> output, HttpWriter http) {
        return http.writeTokenList(this.versions.iterator(), output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof SecWebSocketVersion) {
            SecWebSocketVersion that = (SecWebSocketVersion)other;
            return this.versions.equals(that.versions);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(SecWebSocketVersion.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.versions.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("SecWebSocketVersion").write(46).write("from").write(40);
        int n = this.versions.size();
        if (n > 0) {
            output.debug(this.versions.head());
            for (int i = 1; i < n; ++i) {
                output = output.write(", ").debug(this.versions.get(i));
            }
        }
        output = output.write(41);
    }
}

