/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Base10;
import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.collections.FingerTrieSeq;
import swim.http.Http;
import swim.http.header.SecWebSocketVersion;
import swim.util.Builder;

final class SecWebSocketVersionParser
extends Parser<SecWebSocketVersion> {
    final int version;
    final Builder<Integer, FingerTrieSeq<Integer>> versions;
    final int step;

    SecWebSocketVersionParser(int version, Builder<Integer, FingerTrieSeq<Integer>> versions, int step) {
        this.version = version;
        this.versions = versions;
        this.step = step;
    }

    SecWebSocketVersionParser() {
        this(0, null, 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Parser<SecWebSocketVersion> parse(Input input, int version, Builder<Integer, FingerTrieSeq<Integer>> versions, int step) {
        int c = 0;
        if (step == 1) {
            if (input.isCont()) {
                c = input.head();
                if (c == 48) {
                    input = input.step();
                    if (versions == null) {
                        versions = FingerTrieSeq.builder();
                    }
                    versions.add((Object)0);
                    version = 0;
                    step = 3;
                } else {
                    if (c < 49 || c > 57) return SecWebSocketVersionParser.error((Diagnostic)Diagnostic.expected((String)"websocket version", (Input)input));
                    input = input.step();
                    version = Base10.decodeDigit((int)c);
                    step = 2;
                }
            } else if (input.isDone()) {
                return SecWebSocketVersionParser.error((Diagnostic)Diagnostic.expected((String)"websocket version", (Input)input));
            }
        }
        if (step == 2) {
            while (input.isCont() && Base10.isDigit((int)(c = input.head()))) {
                input = input.step();
                if ((version = 10 * version + Base10.decodeDigit((int)c)) >= 0) continue;
                return SecWebSocketVersionParser.error((Diagnostic)Diagnostic.message((String)"websocket version overflow", (Input)input));
            }
            if (!input.isEmpty()) {
                if (versions == null) {
                    versions = FingerTrieSeq.builder();
                }
                versions.add((Object)version);
                version = 0;
                step = 3;
            }
        }
        while (true) {
            if (step == 3) {
                while (input.isCont() && Http.isSpace(c = input.head())) {
                    input = input.step();
                }
                if (input.isCont() && c == 44) {
                    input = input.step();
                    step = 4;
                } else if (!input.isEmpty()) {
                    return SecWebSocketVersionParser.done((Object)SecWebSocketVersion.from((FingerTrieSeq<Integer>)((FingerTrieSeq)versions.bind())));
                }
            }
            if (step == 4) {
                while (input.isCont() && Http.isSpace(c = input.head())) {
                    input = input.step();
                }
                if (input.isCont()) {
                    step = 5;
                } else if (input.isDone()) {
                    return SecWebSocketVersionParser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                }
            }
            if (step == 5) {
                if (input.isCont()) {
                    c = input.head();
                    if (c == 48) {
                        input = input.step();
                        versions.add((Object)0);
                        version = 0;
                        step = 3;
                        continue;
                    }
                    if (c < 49 || c > 57) return SecWebSocketVersionParser.error((Diagnostic)Diagnostic.expected((String)"websocket version", (Input)input));
                    input = input.step();
                    version = Base10.decodeDigit((int)c);
                    step = 6;
                } else if (input.isDone()) {
                    return SecWebSocketVersionParser.error((Diagnostic)Diagnostic.expected((String)"websocket version", (Input)input));
                }
            }
            if (step != 6) break;
            while (input.isCont() && Base10.isDigit((int)(c = input.head()))) {
                input = input.step();
                if ((version = 10 * version + Base10.decodeDigit((int)c)) >= 0) continue;
                return SecWebSocketVersionParser.error((Diagnostic)Diagnostic.message((String)"websocket version overflow", (Input)input));
            }
            if (input.isEmpty()) break;
            versions.add((Object)version);
            version = 0;
            step = 3;
        }
        if (!input.isError()) return new SecWebSocketVersionParser(version, (Builder<Integer, FingerTrieSeq<Integer>>)versions, step);
        return SecWebSocketVersionParser.error((Throwable)input.trap());
    }

    static Parser<SecWebSocketVersion> parse(Input input) {
        return SecWebSocketVersionParser.parse(input, 0, null, 1);
    }

    public Parser<SecWebSocketVersion> feed(Input input) {
        return SecWebSocketVersionParser.parse(input, this.version, this.versions, this.step);
    }
}

