/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.collections.FingerTrieSeq;
import swim.http.Http;
import swim.http.HttpParser;
import swim.http.TransferCoding;
import swim.http.header.TransferEncoding;
import swim.util.Builder;

final class TransferEncodingParser
extends Parser<TransferEncoding> {
    final HttpParser http;
    final Parser<TransferCoding> coding;
    final Builder<TransferCoding, FingerTrieSeq<TransferCoding>> codings;
    final int step;

    TransferEncodingParser(HttpParser http, Parser<TransferCoding> coding, Builder<TransferCoding, FingerTrieSeq<TransferCoding>> codings, int step) {
        this.http = http;
        this.coding = coding;
        this.codings = codings;
        this.step = step;
    }

    TransferEncodingParser(HttpParser http) {
        this(http, null, null, 1);
    }

    static Parser<TransferEncoding> parse(Input input, HttpParser http, Parser<TransferCoding> coding, Builder<TransferCoding, FingerTrieSeq<TransferCoding>> codings, int step) {
        block18: {
            int c = 0;
            if (step == 1) {
                if ((coding = coding == null ? http.parseTransferCoding(input) : coding.feed(input)).isDone()) {
                    if (codings == null) {
                        codings = FingerTrieSeq.builder();
                    }
                    codings.add((Object)((TransferCoding)coding.bind()));
                    coding = null;
                    step = 2;
                } else if (coding.isError()) {
                    return coding.asError();
                }
            }
            while (true) {
                if (step == 2) {
                    while (input.isCont() && Http.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (input.isCont() && c == 44) {
                        input = input.step();
                        step = 3;
                    } else if (!input.isEmpty()) {
                        return TransferEncodingParser.done((Object)TransferEncoding.from((FingerTrieSeq<TransferCoding>)((FingerTrieSeq)codings.bind())));
                    }
                }
                if (step == 3) {
                    while (input.isCont() && Http.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (input.isCont()) {
                        step = 4;
                    } else if (input.isDone()) {
                        return TransferEncodingParser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                    }
                }
                if (step != 4) break block18;
                if (!(coding = coding == null ? http.parseTransferCoding(input) : coding.feed(input)).isDone()) break;
                codings.add((Object)((TransferCoding)coding.bind()));
                coding = null;
                step = 2;
            }
            if (coding.isError()) {
                return coding.asError();
            }
        }
        if (input.isError()) {
            return TransferEncodingParser.error((Throwable)input.trap());
        }
        return new TransferEncodingParser(http, (Parser<TransferCoding>)coding, (Builder<TransferCoding, FingerTrieSeq<TransferCoding>>)codings, step);
    }

    static Parser<TransferEncoding> parse(Input input, HttpParser http) {
        return TransferEncodingParser.parse(input, http, null, null, 1);
    }

    public Parser<TransferEncoding> feed(Input input) {
        return TransferEncodingParser.parse(input, this.http, this.coding, this.codings, this.step);
    }
}

