/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Writer;
import swim.collections.FingerTrieSeq;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.UpgradeProtocol;
import swim.http.header.UpgradeParser;
import swim.util.Builder;
import swim.util.Murmur3;

public final class Upgrade
extends HttpHeader {
    private static int hashSeed;
    private static Upgrade websocket;
    final FingerTrieSeq<UpgradeProtocol> protocols;

    Upgrade(FingerTrieSeq<UpgradeProtocol> protocols) {
        this.protocols = protocols;
    }

    public static Upgrade websocket() {
        if (websocket == null) {
            websocket = new Upgrade((FingerTrieSeq<UpgradeProtocol>)FingerTrieSeq.of((Object[])new UpgradeProtocol[]{UpgradeProtocol.websocket()}));
        }
        return websocket;
    }

    public static Upgrade from(FingerTrieSeq<UpgradeProtocol> protocols) {
        UpgradeProtocol protocol;
        if (protocols.size() == 1 && (protocol = (UpgradeProtocol)protocols.head()) == UpgradeProtocol.websocket()) {
            return Upgrade.websocket();
        }
        return new Upgrade(protocols);
    }

    public static Upgrade from(UpgradeProtocol ... protocols) {
        return Upgrade.from((FingerTrieSeq<UpgradeProtocol>)FingerTrieSeq.of((Object[])protocols));
    }

    public static Upgrade from(String ... protocolStrings) {
        Builder protocols = FingerTrieSeq.builder();
        int n = protocolStrings.length;
        for (int i = 0; i < n; ++i) {
            protocols.add((Object)UpgradeProtocol.parse(protocolStrings[i]));
        }
        return Upgrade.from((FingerTrieSeq<UpgradeProtocol>)((FingerTrieSeq)protocols.bind()));
    }

    public static Parser<Upgrade> parseHttpValue(Input input, HttpParser http) {
        return UpgradeParser.parse(input, http);
    }

    @Override
    public String lowerCaseName() {
        return "upgrade";
    }

    @Override
    public String name() {
        return "Upgrade";
    }

    public FingerTrieSeq<UpgradeProtocol> protocols() {
        return this.protocols;
    }

    public boolean supports(UpgradeProtocol protocol) {
        FingerTrieSeq<UpgradeProtocol> protocols = this.protocols;
        int n = protocols.size();
        for (int i = 0; i < n; ++i) {
            if (!protocol.matches((UpgradeProtocol)protocols.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Writer<?, ?> writeHttpValue(Output<?> output, HttpWriter http) {
        return http.writeParamList(this.protocols.iterator(), output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Upgrade) {
            Upgrade that = (Upgrade)other;
            return this.protocols.equals(that.protocols);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(Upgrade.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.protocols.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("Upgrade").write(46).write("from").write(40);
        int n = this.protocols.size();
        if (n > 0) {
            output.debug(this.protocols.head());
            for (int i = 1; i < n; ++i) {
                output = output.write(", ").debug(this.protocols.get(i));
            }
        }
        output = output.write(41);
    }
}

