/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.collections.FingerTrieSeq;
import swim.http.Http;
import swim.http.HttpParser;
import swim.http.UpgradeProtocol;
import swim.http.header.Upgrade;
import swim.util.Builder;

final class UpgradeParser
extends Parser<Upgrade> {
    final HttpParser http;
    final Parser<UpgradeProtocol> protocol;
    final Builder<UpgradeProtocol, FingerTrieSeq<UpgradeProtocol>> protocols;
    final int step;

    UpgradeParser(HttpParser http, Parser<UpgradeProtocol> protocol, Builder<UpgradeProtocol, FingerTrieSeq<UpgradeProtocol>> protocols, int step) {
        this.http = http;
        this.protocol = protocol;
        this.protocols = protocols;
        this.step = step;
    }

    UpgradeParser(HttpParser http) {
        this(http, null, null, 1);
    }

    static Parser<Upgrade> parse(Input input, HttpParser http, Parser<UpgradeProtocol> protocol, Builder<UpgradeProtocol, FingerTrieSeq<UpgradeProtocol>> protocols, int step) {
        block18: {
            int c = 0;
            if (step == 1) {
                if ((protocol = protocol == null ? http.parseUpgradeProtocol(input) : protocol.feed(input)).isDone()) {
                    if (protocols == null) {
                        protocols = FingerTrieSeq.builder();
                    }
                    protocols.add((Object)((UpgradeProtocol)protocol.bind()));
                    protocol = null;
                    step = 2;
                } else if (protocol.isError()) {
                    return protocol.asError();
                }
            }
            while (true) {
                if (step == 2) {
                    while (input.isCont() && Http.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (input.isCont() && c == 44) {
                        input = input.step();
                        step = 3;
                    } else if (!input.isEmpty()) {
                        return UpgradeParser.done((Object)Upgrade.from((FingerTrieSeq<UpgradeProtocol>)((FingerTrieSeq)protocols.bind())));
                    }
                }
                if (step == 3) {
                    while (input.isCont() && Http.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (input.isCont()) {
                        step = 4;
                    } else if (input.isDone()) {
                        return UpgradeParser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                    }
                }
                if (step != 4) break block18;
                if (!(protocol = protocol == null ? http.parseUpgradeProtocol(input) : protocol.feed(input)).isDone()) break;
                protocols.add((Object)((UpgradeProtocol)protocol.bind()));
                protocol = null;
                step = 2;
            }
            if (protocol.isError()) {
                return protocol.asError();
            }
        }
        if (input.isError()) {
            return UpgradeParser.error((Throwable)input.trap());
        }
        return new UpgradeParser(http, (Parser<UpgradeProtocol>)protocol, (Builder<UpgradeProtocol, FingerTrieSeq<UpgradeProtocol>>)protocols, step);
    }

    static Parser<Upgrade> parse(Input input, HttpParser http) {
        return UpgradeParser.parse(input, http, null, null, 1);
    }

    public Parser<Upgrade> feed(Input input) {
        return UpgradeParser.parse(input, this.http, this.protocol, this.protocols, this.step);
    }
}

