/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Parser;
import swim.collections.FingerTrieSeq;
import swim.http.Http;
import swim.http.HttpParser;
import swim.http.Product;
import swim.http.header.UserAgent;
import swim.util.Builder;

final class UserAgentParser
extends Parser<UserAgent> {
    final HttpParser http;
    final Parser<Product> product;
    final Builder<Product, FingerTrieSeq<Product>> products;
    final int step;

    UserAgentParser(HttpParser http, Parser<Product> product, Builder<Product, FingerTrieSeq<Product>> products, int step) {
        this.http = http;
        this.product = product;
        this.products = products;
        this.step = step;
    }

    UserAgentParser(HttpParser http) {
        this(http, null, null, 1);
    }

    static Parser<UserAgent> parse(Input input, HttpParser http, Parser<Product> product, Builder<Product, FingerTrieSeq<Product>> products, int step) {
        block13: {
            int c = 0;
            if (step == 1) {
                if ((product = product == null ? http.parseProduct(input) : product.feed(input)).isDone()) {
                    if (products == null) {
                        products = FingerTrieSeq.builder();
                    }
                    products.add((Object)((Product)product.bind()));
                    product = null;
                    step = 2;
                } else if (product.isError()) {
                    return product.asError();
                }
            }
            while (true) {
                if (step == 2) {
                    while (input.isCont() && Http.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (input.isCont() && Http.isTokenChar(c)) {
                        step = 3;
                    } else if (!input.isEmpty()) {
                        return UserAgentParser.done((Object)UserAgent.from((FingerTrieSeq<Product>)((FingerTrieSeq)products.bind())));
                    }
                }
                if (step != 3) break block13;
                if (!(product = product == null ? http.parseProduct(input) : product.feed(input)).isDone()) break;
                products.add((Object)((Product)product.bind()));
                product = null;
                step = 2;
            }
            if (product.isError()) {
                return product.asError();
            }
        }
        if (input.isError()) {
            return UserAgentParser.error((Throwable)input.trap());
        }
        return new UserAgentParser(http, (Parser<Product>)product, (Builder<Product, FingerTrieSeq<Product>>)products, step);
    }

    static Parser<UserAgent> parse(Input input, HttpParser http) {
        return UserAgentParser.parse(input, http, null, null, 1);
    }

    public Parser<UserAgent> feed(Input input) {
        return UserAgentParser.parse(input, this.http, this.product, this.products, this.step);
    }
}

