/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.http.Http;
import swim.http.HttpCharset;
import swim.http.HttpParser;

final class HttpCharsetParser
extends Parser<HttpCharset> {
    final HttpParser http;
    final StringBuilder nameBuilder;
    final Parser<Float> weightParser;
    final int step;

    HttpCharsetParser(HttpParser http, StringBuilder nameBuilder, Parser<Float> weightParser, int step) {
        this.http = http;
        this.nameBuilder = nameBuilder;
        this.weightParser = weightParser;
        this.step = step;
    }

    HttpCharsetParser(HttpParser http) {
        this(http, null, null, 1);
    }

    public Parser<HttpCharset> feed(Input input) {
        return HttpCharsetParser.parse(input, this.http, this.nameBuilder, this.weightParser, this.step);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Parser<HttpCharset> parse(Input input, HttpParser http, StringBuilder nameBuilder, Parser<Float> weightParser2222, int step) {
        int c = 0;
        if (step == 1) {
            if (input.isCont()) {
                c = input.head();
                if (!Http.isTokenChar(c)) return Parser.error((Diagnostic)Diagnostic.expected((String)"charset", (Input)input));
                input = input.step();
                if (nameBuilder == null) {
                    nameBuilder = new StringBuilder();
                }
                nameBuilder.appendCodePoint(c);
                step = 2;
            } else if (input.isDone()) {
                return Parser.error((Diagnostic)Diagnostic.expected((String)"charset", (Input)input));
            }
        }
        if (step == 2) {
            while (input.isCont() && Http.isTokenChar(c = input.head())) {
                input = input.step();
                nameBuilder.appendCodePoint(c);
            }
            if (!input.isEmpty()) {
                step = 3;
            }
        }
        if (step == 3) {
            void weightParser2222;
            if (weightParser2222 == null) {
                Parser<Float> weightParser2222 = http.parseQValue(input);
            } else {
                Object weightParser2222;
                Parser weightParser2222 = weightParser2222.feed(input);
            }
            if (weightParser2222.isDone()) {
                Float qvalue = (Float)weightParser2222.bind();
                float q = qvalue != null ? qvalue.floatValue() : 1.0f;
                return Parser.done((Object)http.charset(nameBuilder.toString(), q));
            }
            if (weightParser2222.isError()) {
                return weightParser2222.asError();
            }
        }
        if (!input.isError()) void weightParser2222;
        return new HttpCharsetParser(http, nameBuilder, (Parser<Float>)weightParser2222, step);
        return Parser.error((Throwable)input.trap());
    }

    static Parser<HttpCharset> parse(Input input, HttpParser http) {
        return HttpCharsetParser.parse(input, http, null, null, 1);
    }
}

