/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Encoder;
import swim.codec.EncoderException;
import swim.codec.OutputBuffer;
import swim.codec.Utf8;
import swim.codec.Writer;
import swim.http.HttpChunkHeader;
import swim.http.HttpWriter;

final class HttpChunkEncoder
extends Encoder<Object, Object> {
    final HttpWriter http;
    final HttpChunkHeader header;
    final Encoder<?, ?> payloadEncoder;
    final Writer<?, ?> part;
    final int step;

    HttpChunkEncoder(HttpWriter http, HttpChunkHeader header, Encoder<?, ?> payloadEncoder, Writer<?, ?> part, int step) {
        this.http = http;
        this.header = header;
        this.payloadEncoder = payloadEncoder;
        this.part = part;
        this.step = step;
    }

    HttpChunkEncoder(HttpWriter http, HttpChunkHeader header, Encoder<?, ?> payloadEncoder) {
        this(http, header, payloadEncoder, null, 1);
    }

    public Encoder<Object, Object> pull(OutputBuffer<?> output) {
        return HttpChunkEncoder.encode(output, this.http, this.header, this.payloadEncoder, this.part, this.step);
    }

    static Encoder<Object, Object> encode(OutputBuffer<?> output, HttpWriter http, HttpChunkHeader header, Encoder<?, ?> payloadEncoder, Writer<?, ?> part, int step) {
        if (step == 1) {
            if ((part = part == null ? Utf8.writeEncoded(output, header.httpWriter(http)) : part.pull(output)).isDone()) {
                part = null;
                step = 2;
            } else if (part.isError()) {
                return Encoder.error((Throwable)part.trap());
            }
        }
        if (step == 2) {
            if ((payloadEncoder = payloadEncoder.pull(output)).isDone()) {
                step = 3;
            } else if (payloadEncoder.isError()) {
                return payloadEncoder.asError();
            }
        }
        if (step == 3 && output.isCont()) {
            output = output.write(13);
            step = 4;
        }
        if (step == 4 && output.isCont()) {
            output = output.write(10);
            return Encoder.done();
        }
        if (output.isDone()) {
            return Encoder.error((Throwable)new EncoderException("truncated"));
        }
        if (output.isError()) {
            return Encoder.error((Throwable)output.trap());
        }
        return new HttpChunkEncoder(http, header, payloadEncoder, part, step);
    }

    static Encoder<Object, Object> encode(OutputBuffer<?> output, HttpWriter http, HttpChunkHeader header, Encoder<?, ?> payloadEncoder) {
        return HttpChunkEncoder.encode(output, http, header, payloadEncoder, null, 1);
    }
}

