/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Encoder;
import swim.codec.EncoderException;
import swim.codec.OutputBuffer;
import swim.codec.Utf8;
import swim.codec.Writer;
import swim.http.HttpMessage;
import swim.http.HttpWriter;

final class HttpMessageEncoder<T>
extends Encoder<Object, HttpMessage<T>> {
    final HttpWriter http;
    final HttpMessage<T> message;
    final Object part;
    final int step;

    HttpMessageEncoder(HttpWriter http, HttpMessage<T> message, Object part, int step) {
        this.http = http;
        this.message = message;
        this.part = part;
        this.step = step;
    }

    HttpMessageEncoder(HttpWriter http, HttpMessage<T> message) {
        this(http, message, null, 1);
    }

    public Encoder<Object, HttpMessage<T>> pull(OutputBuffer<?> output) {
        return HttpMessageEncoder.encode(output, this.http, this.message, this.part, this.step);
    }

    static <T> Encoder<Object, HttpMessage<T>> encode(OutputBuffer<?> output, HttpWriter http, HttpMessage<T> message, Object part, int step) {
        if (step == 1) {
            Writer writer = part = part == null ? Utf8.writeEncoded(output, message.httpWriter(http)) : ((Writer)part).pull(output);
            if (writer.isDone()) {
                part = null;
                step = 2;
            } else if (writer.isError()) {
                return writer.asError();
            }
        }
        if (step == 2) {
            Writer encoder = part = part == null ? message.payload().encodeHttp(output, message, http) : ((Encoder)part).pull(output);
            if (encoder.isDone()) {
                return encoder.asDone();
            }
            if (encoder.isError()) {
                return encoder.asError();
            }
        }
        if (output.isDone()) {
            return Encoder.error((Throwable)new EncoderException("truncated"));
        }
        if (output.isError()) {
            return Encoder.error((Throwable)output.trap());
        }
        return new HttpMessageEncoder<T>(http, message, part, step);
    }

    static <T> Encoder<Object, HttpMessage<T>> encode(OutputBuffer<?> output, HttpWriter http, HttpMessage<T> message) {
        return HttpMessageEncoder.encode(output, http, message, null, 1);
    }
}

