/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Base10;
import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Utf8;
import swim.http.Http;
import swim.http.HttpParser;
import swim.http.HttpStatus;

final class HttpStatusParser
extends Parser<HttpStatus> {
    final HttpParser http;
    final int code;
    final Output<String> phraseBuilder;
    final int step;

    HttpStatusParser(HttpParser http, int code, Output<String> phraseBuilder, int step) {
        this.http = http;
        this.code = code;
        this.phraseBuilder = phraseBuilder;
        this.step = step;
    }

    HttpStatusParser(HttpParser http) {
        this(http, 0, null, 1);
    }

    public Parser<HttpStatus> feed(Input input) {
        return HttpStatusParser.parse(input, this.http, this.code, this.phraseBuilder, this.step);
    }

    static Parser<HttpStatus> parse(Input input, HttpParser http, int code, Output<String> phraseBuilder, int step) {
        int c = 0;
        while (step <= 3) {
            if (input.isCont()) {
                c = input.head();
                if (Base10.isDigit((int)c)) {
                    input = input.step();
                    code = 10 * code + Base10.decodeDigit((int)c);
                    ++step;
                    continue;
                }
                return Parser.error((Diagnostic)Diagnostic.expected((String)"status code", (Input)input));
            }
            if (!input.isDone()) break;
            return Parser.error((Diagnostic)Diagnostic.expected((String)"status code", (Input)input));
        }
        if (step == 4) {
            if (input.isCont() && input.head() == 32) {
                input = input.step();
                step = 5;
            } else if (!input.isEmpty()) {
                return Parser.error((Diagnostic)Diagnostic.expected((String)"space", (Input)input));
            }
        }
        if (step == 5) {
            if (phraseBuilder == null) {
                phraseBuilder = Utf8.decodedString();
            }
            while (input.isCont() && Http.isPhraseChar(c = input.head())) {
                input = input.step();
                phraseBuilder.write(c);
            }
            if (!input.isEmpty()) {
                return Parser.done((Object)http.status(code, (String)phraseBuilder.bind()));
            }
        }
        if (input.isError()) {
            return Parser.error((Throwable)input.trap());
        }
        return new HttpStatusParser(http, code, (Output<String>)phraseBuilder, step);
    }

    static Parser<HttpStatus> parse(Input input, HttpParser http) {
        return HttpStatusParser.parse(input, http, 0, null, 1);
    }
}

