/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.collections.FingerTrieSeq;
import swim.http.Http;
import swim.util.Builder;

final class TokenListParser
extends Parser<FingerTrieSeq<String>> {
    final StringBuilder tokenBuilder;
    final Builder<String, FingerTrieSeq<String>> tokens;
    final int step;

    TokenListParser(StringBuilder tokenBuilder, Builder<String, FingerTrieSeq<String>> tokens, int step) {
        this.tokenBuilder = tokenBuilder;
        this.tokens = tokens;
        this.step = step;
    }

    public Parser<FingerTrieSeq<String>> feed(Input input) {
        return TokenListParser.parse(input, this.tokenBuilder, this.tokens, this.step);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Parser<FingerTrieSeq<String>> parse(Input input, StringBuilder tokenBuilder, Builder<String, FingerTrieSeq<String>> tokens, int step) {
        int c = 0;
        if (step == 1) {
            if (input.isCont()) {
                c = input.head();
                if (!Http.isTokenChar(c)) return Parser.done((Object)FingerTrieSeq.empty());
                input = input.step();
                tokenBuilder = new StringBuilder();
                tokenBuilder.appendCodePoint(c);
                step = 2;
            } else if (input.isDone()) {
                return Parser.done((Object)FingerTrieSeq.empty());
            }
        }
        if (step == 2) {
            while (input.isCont() && Http.isTokenChar(c = input.head())) {
                input = input.step();
                tokenBuilder.appendCodePoint(c);
            }
            if (!input.isEmpty()) {
                if (tokens == null) {
                    tokens = FingerTrieSeq.builder();
                }
                tokens.add((Object)tokenBuilder.toString());
                tokenBuilder = null;
                step = 3;
            }
        }
        while (true) {
            if (step == 3) {
                while (input.isCont() && Http.isSpace(c = input.head())) {
                    input = input.step();
                }
                if (input.isCont() && c == 44) {
                    input = input.step();
                    step = 4;
                } else if (!input.isEmpty()) {
                    return Parser.done((Object)((FingerTrieSeq)tokens.bind()));
                }
            }
            if (step == 4) {
                while (input.isCont() && Http.isSpace(c = input.head())) {
                    input = input.step();
                }
                if (input.isCont()) {
                    if (!Http.isTokenChar(c)) return Parser.error((Diagnostic)Diagnostic.expected((String)"token", (Input)input));
                    input = input.step();
                    tokenBuilder = new StringBuilder();
                    tokenBuilder.appendCodePoint(c);
                    step = 5;
                } else if (input.isDone()) {
                    return Parser.error((Diagnostic)Diagnostic.expected((String)"token", (Input)input));
                }
            }
            if (step != 5) break;
            while (input.isCont() && Http.isTokenChar(c = input.head())) {
                input = input.step();
                tokenBuilder.appendCodePoint(c);
            }
            if (input.isEmpty()) break;
            tokens.add((Object)tokenBuilder.toString());
            tokenBuilder = null;
            step = 3;
        }
        if (!input.isError()) return new TokenListParser(tokenBuilder, (Builder<String, FingerTrieSeq<String>>)tokens, step);
        return Parser.error((Throwable)input.trap());
    }

    static Parser<FingerTrieSeq<String>> parse(Input input) {
        return TokenListParser.parse(input, null, null, 1);
    }
}

