/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.collections.HashTrieMap;
import swim.http.Http;
import swim.http.HttpParser;
import swim.http.TransferCoding;

final class TransferCodingParser
extends Parser<TransferCoding> {
    final HttpParser http;
    final StringBuilder nameBuilder;
    final Parser<HashTrieMap<String, String>> paramsParser;
    final int step;

    TransferCodingParser(HttpParser http, StringBuilder nameBuilder, Parser<HashTrieMap<String, String>> paramsParser, int step) {
        this.http = http;
        this.nameBuilder = nameBuilder;
        this.paramsParser = paramsParser;
        this.step = step;
    }

    TransferCodingParser(HttpParser http) {
        this(http, null, null, 1);
    }

    public Parser<TransferCoding> feed(Input input) {
        return TransferCodingParser.parse(input, this.http, this.nameBuilder, this.paramsParser, this.step);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Parser<TransferCoding> parse(Input input, HttpParser http, StringBuilder nameBuilder, Parser<HashTrieMap<String, String>> paramsParser2222, int step) {
        int c = 0;
        if (step == 1) {
            if (input.isCont()) {
                c = input.head();
                if (!Http.isTokenChar(c)) return Parser.error((Diagnostic)Diagnostic.expected((String)"transfer coding", (Input)input));
                input = input.step();
                if (nameBuilder == null) {
                    nameBuilder = new StringBuilder();
                }
                nameBuilder.appendCodePoint(c);
                step = 2;
            } else if (input.isDone()) {
                return Parser.error((Diagnostic)Diagnostic.expected((String)"transfer coding", (Input)input));
            }
        }
        if (step == 2) {
            while (input.isCont() && Http.isTokenChar(c = input.head())) {
                input = input.step();
                nameBuilder.appendCodePoint(c);
            }
            if (input.isCont()) {
                step = 3;
            } else if (input.isDone()) {
                return Parser.done((Object)http.transferCoding(nameBuilder.toString(), (HashTrieMap<String, String>)HashTrieMap.empty()));
            }
        }
        if (step == 3) {
            void paramsParser2222;
            if (paramsParser2222 == null) {
                Parser<HashTrieMap<String, String>> paramsParser2222 = http.parseParamMap(input);
            } else {
                Object paramsParser2222;
                Parser paramsParser2222 = paramsParser2222.feed(input);
            }
            if (paramsParser2222.isDone()) {
                return Parser.done((Object)http.transferCoding(nameBuilder.toString(), (HashTrieMap<String, String>)((HashTrieMap)paramsParser2222.bind())));
            }
            if (paramsParser2222.isError()) {
                return paramsParser2222.asError();
            }
        }
        if (!input.isError()) void paramsParser2222;
        return new TransferCodingParser(http, nameBuilder, (Parser<HashTrieMap<String, String>>)paramsParser2222, step);
        return Parser.error((Throwable)input.trap());
    }

    static Parser<TransferCoding> parse(Input input, HttpParser http) {
        return TransferCodingParser.parse(input, http, null, null, 1);
    }
}

