/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.http.Http;
import swim.http.HttpParser;
import swim.http.WebSocketParam;

final class WebSocketParamParser
extends Parser<WebSocketParam> {
    final HttpParser http;
    final StringBuilder keyBuilder;
    final StringBuilder valueBuilder;
    final int step;

    WebSocketParamParser(HttpParser http, StringBuilder keyBuilder, StringBuilder valueBuilder, int step) {
        this.http = http;
        this.keyBuilder = keyBuilder;
        this.valueBuilder = valueBuilder;
        this.step = step;
    }

    WebSocketParamParser(HttpParser http) {
        this(http, null, null, 1);
    }

    public Parser<WebSocketParam> feed(Input input) {
        return WebSocketParamParser.parse(input, this.http, this.keyBuilder, this.valueBuilder, this.step);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Parser<WebSocketParam> parse(Input input, HttpParser http, StringBuilder keyBuilder, StringBuilder valueBuilder, int step) {
        block36: {
            int c = 0;
            if (step == 1) {
                if (input.isCont()) {
                    c = input.head();
                    if (!Http.isTokenChar(c)) return Parser.error((Diagnostic)Diagnostic.expected((String)"param name", (Input)input));
                    input = input.step();
                    if (keyBuilder == null) {
                        keyBuilder = new StringBuilder();
                    }
                    keyBuilder.appendCodePoint(c);
                    step = 2;
                } else if (input.isDone()) {
                    return Parser.error((Diagnostic)Diagnostic.expected((String)"param name", (Input)input));
                }
            }
            if (step == 2) {
                while (input.isCont() && Http.isTokenChar(c = input.head())) {
                    input = input.step();
                    keyBuilder.appendCodePoint(c);
                }
                if (!input.isEmpty()) {
                    step = 3;
                }
            }
            if (step == 3) {
                while (input.isCont() && Http.isSpace(c = input.head())) {
                    input = input.step();
                }
                if (input.isCont() && c == 61) {
                    input = input.step();
                    step = 4;
                } else if (!input.isEmpty()) {
                    return Parser.done((Object)http.webSocketParam(keyBuilder.toString(), ""));
                }
            }
            if (step == 4) {
                while (input.isCont() && Http.isSpace(c = input.head())) {
                    input = input.step();
                }
                if (input.isCont()) {
                    if (valueBuilder == null) {
                        valueBuilder = new StringBuilder();
                    }
                    if (c == 34) {
                        input = input.step();
                        step = 7;
                    } else {
                        step = 5;
                    }
                } else if (input.isDone()) {
                    return Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                }
            }
            if (step == 5) {
                if (input.isCont()) {
                    c = input.head();
                    if (!Http.isTokenChar(c)) return Parser.error((Diagnostic)Diagnostic.expected((String)"param value", (Input)input));
                    input = input.step();
                    valueBuilder.appendCodePoint(c);
                    step = 6;
                } else if (input.isDone()) {
                    return Parser.error((Diagnostic)Diagnostic.expected((String)"param value", (Input)input));
                }
            }
            if (step == 6) {
                while (input.isCont() && Http.isTokenChar(c = input.head())) {
                    input = input.step();
                    valueBuilder.appendCodePoint(c);
                }
                if (!input.isEmpty()) {
                    return Parser.done((Object)http.webSocketParam(keyBuilder.toString(), valueBuilder.toString()));
                }
            }
            while (true) {
                if (step == 7) {
                    while (input.isCont() && Http.isQuotedChar(c = input.head())) {
                        input = input.step();
                        valueBuilder.appendCodePoint(c);
                    }
                    if (input.isCont()) {
                        if (c == 34) {
                            input = input.step();
                            return WebSocketParamParser.done((Object)http.webSocketParam(keyBuilder.toString(), valueBuilder.toString()));
                        }
                        if (c != 92) return Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                        input = input.step();
                        step = 8;
                    } else if (input.isDone()) {
                        return Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                    }
                }
                if (step != 8) break block36;
                if (!input.isCont()) break;
                c = input.head();
                if (!Http.isEscapeChar(c)) return Parser.error((Diagnostic)Diagnostic.expected((String)"escape character", (Input)input));
                input = input.step();
                valueBuilder.appendCodePoint(c);
                step = 7;
            }
            if (input.isDone()) {
                return Parser.error((Diagnostic)Diagnostic.expected((String)"escape character", (Input)input));
            }
        }
        if (!input.isError()) return new WebSocketParamParser(http, keyBuilder, valueBuilder, step);
        return Parser.error((Throwable)input.trap());
    }

    static Parser<WebSocketParam> parse(Input input, HttpParser http) {
        return WebSocketParamParser.parse(input, http, null, null, 1);
    }
}

