/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Writer;
import swim.collections.FingerTrieSeq;
import swim.http.HttpCharset;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.header.AcceptCharsetHeaderParser;
import swim.util.Builder;
import swim.util.Murmur3;

public final class AcceptCharsetHeader
extends HttpHeader {
    final FingerTrieSeq<HttpCharset> charsets;
    private static int hashSeed;

    AcceptCharsetHeader(FingerTrieSeq<HttpCharset> charsets) {
        this.charsets = charsets;
    }

    @Override
    public boolean isBlank() {
        return this.charsets.isEmpty();
    }

    @Override
    public String lowerCaseName() {
        return "accept-charset";
    }

    @Override
    public String name() {
        return "Accept-Charset";
    }

    public FingerTrieSeq<HttpCharset> charsets() {
        return this.charsets;
    }

    @Override
    public Writer<?, ?> writeHeaderValue(Output<?> output, HttpWriter http) {
        return http.writeParamList(output, this.charsets.iterator());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof AcceptCharsetHeader) {
            AcceptCharsetHeader that = (AcceptCharsetHeader)other;
            return this.charsets.equals(that.charsets);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(AcceptCharsetHeader.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.charsets.hashCode()));
    }

    @Override
    public <T> Output<T> debug(Output<T> output) {
        output = output.write("AcceptCharsetHeader").write(46).write("create").write(40);
        int n = this.charsets.size();
        if (n > 0) {
            output = output.debug(this.charsets.head());
            for (int i = 1; i < n; ++i) {
                output = output.write(", ").debug(this.charsets.get(i));
            }
        }
        output = output.write(41);
        return output;
    }

    public static AcceptCharsetHeader empty() {
        return new AcceptCharsetHeader((FingerTrieSeq<HttpCharset>)FingerTrieSeq.empty());
    }

    public static AcceptCharsetHeader create(FingerTrieSeq<HttpCharset> charsets) {
        return new AcceptCharsetHeader(charsets);
    }

    public static AcceptCharsetHeader create(HttpCharset ... charsets) {
        return new AcceptCharsetHeader((FingerTrieSeq<HttpCharset>)FingerTrieSeq.of((Object[])charsets));
    }

    public static AcceptCharsetHeader create(String ... charsetStrings) {
        Builder charsets = FingerTrieSeq.builder();
        int n = charsetStrings.length;
        for (int i = 0; i < n; ++i) {
            charsets.add((Object)HttpCharset.parse(charsetStrings[i]));
        }
        return new AcceptCharsetHeader((FingerTrieSeq<HttpCharset>)((FingerTrieSeq)charsets.bind()));
    }

    public static Parser<AcceptCharsetHeader> parseHeaderValue(Input input, HttpParser http) {
        return AcceptCharsetHeaderParser.parse(input, http);
    }
}

