/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.collections.FingerTrieSeq;
import swim.http.ContentCoding;
import swim.http.Http;
import swim.http.HttpParser;
import swim.http.header.AcceptEncodingHeader;
import swim.util.Builder;

final class AcceptEncodingHeaderParser
extends Parser<AcceptEncodingHeader> {
    final HttpParser http;
    final Parser<ContentCoding> codingParser;
    final Builder<ContentCoding, FingerTrieSeq<ContentCoding>> codings;
    final int step;

    AcceptEncodingHeaderParser(HttpParser http, Parser<ContentCoding> codingParser, Builder<ContentCoding, FingerTrieSeq<ContentCoding>> codings, int step) {
        this.http = http;
        this.codingParser = codingParser;
        this.codings = codings;
        this.step = step;
    }

    AcceptEncodingHeaderParser(HttpParser http) {
        this(http, null, null, 1);
    }

    public Parser<AcceptEncodingHeader> feed(Input input) {
        return AcceptEncodingHeaderParser.parse(input, this.http, this.codingParser, this.codings, this.step);
    }

    static Parser<AcceptEncodingHeader> parse(Input input, HttpParser http, Parser<ContentCoding> codingParser, Builder<ContentCoding, FingerTrieSeq<ContentCoding>> codings, int step) {
        block18: {
            int c = 0;
            if (step == 1) {
                if ((codingParser = codingParser == null ? http.parseContentCoding(input) : codingParser.feed(input)).isDone()) {
                    if (codings == null) {
                        codings = FingerTrieSeq.builder();
                    }
                    codings.add((Object)((ContentCoding)codingParser.bind()));
                    codingParser = null;
                    step = 2;
                } else if (codingParser.isError()) {
                    return codingParser.asError();
                }
            }
            while (true) {
                if (step == 2) {
                    while (input.isCont() && Http.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (input.isCont() && c == 44) {
                        input = input.step();
                        step = 3;
                    } else if (!input.isEmpty()) {
                        return Parser.done((Object)AcceptEncodingHeader.create((FingerTrieSeq<ContentCoding>)((FingerTrieSeq)codings.bind())));
                    }
                }
                if (step == 3) {
                    while (input.isCont() && Http.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (input.isCont()) {
                        step = 4;
                    } else if (input.isDone()) {
                        return Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                    }
                }
                if (step != 4) break block18;
                if (!(codingParser = codingParser == null ? http.parseContentCoding(input) : codingParser.feed(input)).isDone()) break;
                codings.add((Object)((ContentCoding)codingParser.bind()));
                codingParser = null;
                step = 2;
            }
            if (codingParser.isError()) {
                return codingParser.asError();
            }
        }
        if (input.isError()) {
            return Parser.error((Throwable)input.trap());
        }
        return new AcceptEncodingHeaderParser(http, (Parser<ContentCoding>)codingParser, (Builder<ContentCoding, FingerTrieSeq<ContentCoding>>)codings, step);
    }

    static Parser<AcceptEncodingHeader> parse(Input input, HttpParser http) {
        return AcceptEncodingHeaderParser.parse(input, http, null, null, 1);
    }
}

