/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Writer;
import swim.collections.FingerTrieSeq;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.header.ConnectionHeaderParser;
import swim.util.Murmur3;

public final class ConnectionHeader
extends HttpHeader {
    final FingerTrieSeq<String> options;
    private static int hashSeed;
    private static ConnectionHeader close;
    private static ConnectionHeader upgrade;

    ConnectionHeader(FingerTrieSeq<String> options) {
        this.options = options;
    }

    @Override
    public boolean isBlank() {
        return this.options.isEmpty();
    }

    @Override
    public String lowerCaseName() {
        return "connection";
    }

    @Override
    public String name() {
        return "Connection";
    }

    public FingerTrieSeq<String> options() {
        return this.options;
    }

    public boolean contains(String option) {
        FingerTrieSeq<String> options = this.options;
        int n = options.size();
        for (int i = 0; i < n; ++i) {
            if (!option.equalsIgnoreCase((String)options.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Writer<?, ?> writeHeaderValue(Output<?> output, HttpWriter http) {
        return http.writeTokenList(output, this.options.iterator());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ConnectionHeader) {
            ConnectionHeader that = (ConnectionHeader)other;
            return this.options.equals(that.options);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(ConnectionHeader.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.options.hashCode()));
    }

    @Override
    public <T> Output<T> debug(Output<T> output) {
        output = output.write("ConnectionHeader").write(46).write("create").write(40);
        int n = this.options.size();
        if (n > 0) {
            output = output.debug(this.options.head());
            for (int i = 1; i < n; ++i) {
                output = output.write(", ").write((String)this.options.get(i));
            }
        }
        output = output.write(41);
        return output;
    }

    public static ConnectionHeader close() {
        if (close == null) {
            close = new ConnectionHeader((FingerTrieSeq<String>)FingerTrieSeq.of((Object[])new String[]{"close"}));
        }
        return close;
    }

    public static ConnectionHeader upgrade() {
        if (upgrade == null) {
            upgrade = new ConnectionHeader((FingerTrieSeq<String>)FingerTrieSeq.of((Object[])new String[]{"Upgrade"}));
        }
        return upgrade;
    }

    public static ConnectionHeader empty() {
        return new ConnectionHeader((FingerTrieSeq<String>)FingerTrieSeq.empty());
    }

    public static ConnectionHeader create(FingerTrieSeq<String> options) {
        if (options.size() == 1) {
            String option = (String)options.head();
            if ("close".equals(option)) {
                return ConnectionHeader.close();
            }
            if ("Upgrade".equals(option)) {
                return ConnectionHeader.upgrade();
            }
        }
        return new ConnectionHeader(options);
    }

    public static ConnectionHeader create(String ... options) {
        return ConnectionHeader.create((FingerTrieSeq<String>)FingerTrieSeq.of((Object[])options));
    }

    public static Parser<ConnectionHeader> parseHeaderValue(Input input, HttpParser http) {
        return ConnectionHeaderParser.parse(input, http);
    }
}

