/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.collections.FingerTrieSeq;
import swim.http.HttpParser;
import swim.http.header.ContentEncodingHeader;

final class ContentEncodingHeaderParser
extends Parser<ContentEncodingHeader> {
    final HttpParser http;
    final Parser<FingerTrieSeq<String>> codingsParser;

    ContentEncodingHeaderParser(HttpParser http, Parser<FingerTrieSeq<String>> codingsParser) {
        this.http = http;
        this.codingsParser = codingsParser;
    }

    ContentEncodingHeaderParser(HttpParser http) {
        this(http, null);
    }

    public Parser<ContentEncodingHeader> feed(Input input) {
        return ContentEncodingHeaderParser.parse(input, this.http, this.codingsParser);
    }

    static Parser<ContentEncodingHeader> parse(Input input, HttpParser http, Parser<FingerTrieSeq<String>> codingsParser) {
        if ((codingsParser = codingsParser == null ? http.parseTokenList(input) : codingsParser.feed(input)).isDone()) {
            FingerTrieSeq tokens = (FingerTrieSeq)codingsParser.bind();
            if (!tokens.isEmpty()) {
                return Parser.done((Object)ContentEncodingHeader.create((FingerTrieSeq<String>)tokens));
            }
            return Parser.error((Diagnostic)Diagnostic.expected((String)"content coding", (Input)input));
        }
        if (codingsParser.isError()) {
            return codingsParser.asError();
        }
        if (input.isError()) {
            return Parser.error((Throwable)input.trap());
        }
        return new ContentEncodingHeaderParser(http, (Parser<FingerTrieSeq<String>>)codingsParser);
    }

    static Parser<ContentEncodingHeader> parse(Input input, HttpParser http) {
        return ContentEncodingHeaderParser.parse(input, http, null);
    }
}

