/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Base10;
import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Writer;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.header.ContentLengthHeaderParser;
import swim.util.Murmur3;

public final class ContentLengthHeader
extends HttpHeader {
    final long length;
    private static int hashSeed;

    ContentLengthHeader(long length) {
        this.length = length;
    }

    @Override
    public String lowerCaseName() {
        return "content-length";
    }

    @Override
    public String name() {
        return "Content-Length";
    }

    public long length() {
        return this.length;
    }

    @Override
    public Writer<?, ?> writeHeaderValue(Output<?> output, HttpWriter http) {
        return Base10.writeLong(output, (long)this.length);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ContentLengthHeader) {
            ContentLengthHeader that = (ContentLengthHeader)other;
            return this.length == that.length;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(ContentLengthHeader.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash((long)this.length)));
    }

    @Override
    public <T> Output<T> debug(Output<T> output) {
        output = output.write("ContentLengthHeader").write(46).write("create").write(40).debug((Object)this.length).write(41);
        return output;
    }

    public static ContentLengthHeader create(long length) {
        if (length < 0L) {
            throw new IllegalArgumentException(Long.toString(length));
        }
        return new ContentLengthHeader(length);
    }

    public static Parser<ContentLengthHeader> parseHeaderValue(Input input, HttpParser http) {
        return ContentLengthHeaderParser.parse(input);
    }
}

