/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Writer;
import swim.collections.FingerTrieSeq;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.WebSocketExtension;
import swim.http.header.SecWebSocketExtensionsHeaderParser;
import swim.util.Builder;
import swim.util.Murmur3;

public final class SecWebSocketExtensionsHeader
extends HttpHeader {
    final FingerTrieSeq<WebSocketExtension> extensions;
    private static int hashSeed;

    SecWebSocketExtensionsHeader(FingerTrieSeq<WebSocketExtension> extensions) {
        this.extensions = extensions;
    }

    @Override
    public boolean isBlank() {
        return this.extensions.isEmpty();
    }

    @Override
    public String lowerCaseName() {
        return "sec-websocket-extensions";
    }

    @Override
    public String name() {
        return "Sec-WebSocket-Extensions";
    }

    public FingerTrieSeq<WebSocketExtension> extensions() {
        return this.extensions;
    }

    @Override
    public Writer<?, ?> writeHeaderValue(Output<?> output, HttpWriter http) {
        return http.writeParamList(output, this.extensions.iterator());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof SecWebSocketExtensionsHeader) {
            SecWebSocketExtensionsHeader that = (SecWebSocketExtensionsHeader)other;
            return this.extensions.equals(that.extensions);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(SecWebSocketExtensionsHeader.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.extensions.hashCode()));
    }

    @Override
    public <T> Output<T> debug(Output<T> output) {
        output = output.write("SecWebSocketExtensionsHeader").write(46).write("create").write(40);
        int n = this.extensions.size();
        if (n > 0) {
            output = output.debug(this.extensions.head());
            for (int i = 1; i < n; ++i) {
                output = output.write(", ").debug(this.extensions.get(i));
            }
        }
        output = output.write(41);
        return output;
    }

    public static SecWebSocketExtensionsHeader empty() {
        return new SecWebSocketExtensionsHeader((FingerTrieSeq<WebSocketExtension>)FingerTrieSeq.empty());
    }

    public static SecWebSocketExtensionsHeader create(FingerTrieSeq<WebSocketExtension> extensions) {
        return new SecWebSocketExtensionsHeader(extensions);
    }

    public static SecWebSocketExtensionsHeader create(WebSocketExtension ... extensions) {
        return new SecWebSocketExtensionsHeader((FingerTrieSeq<WebSocketExtension>)FingerTrieSeq.of((Object[])extensions));
    }

    public static SecWebSocketExtensionsHeader create(String ... extensionStrings) {
        Builder extensions = FingerTrieSeq.builder();
        int n = extensionStrings.length;
        for (int i = 0; i < n; ++i) {
            extensions.add((Object)WebSocketExtension.parse(extensionStrings[i]));
        }
        return new SecWebSocketExtensionsHeader((FingerTrieSeq<WebSocketExtension>)((FingerTrieSeq)extensions.bind()));
    }

    public static Parser<SecWebSocketExtensionsHeader> parseHeaderValue(Input input, HttpParser http) {
        return SecWebSocketExtensionsHeaderParser.parse(input, http);
    }
}

