/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.http.Http;

final class CommentParser
extends Parser<String> {
    final StringBuilder commentBuilder;
    final int level;
    final int step;

    CommentParser(StringBuilder commentBuilder, int level, int step) {
        this.commentBuilder = commentBuilder;
        this.level = level;
        this.step = step;
    }

    public Parser<String> feed(Input input) {
        return CommentParser.parse(input, this.commentBuilder, this.level, this.step);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Parser<String> parse(Input input, StringBuilder commentBuilder, int level, int step) {
        block15: {
            int c = 0;
            if (step == 1) {
                if (input.isCont() && input.head() == 40) {
                    input = input.step();
                    commentBuilder = new StringBuilder();
                    level = 1;
                    step = 2;
                } else if (!input.isEmpty()) {
                    return Parser.done();
                }
            }
            while (true) {
                if (step == 2) {
                    while (input.isCont() && Http.isCommentChar(c = input.head())) {
                        input = input.step();
                        commentBuilder.appendCodePoint(c);
                    }
                    if (input.isCont()) {
                        if (c == 40) {
                            input = input.step();
                            commentBuilder.append('(');
                            ++level;
                        } else if (c == 41) {
                            input = input.step();
                            if (--level <= 0) return Parser.done((Object)commentBuilder.toString());
                            commentBuilder.append(')');
                        } else {
                            if (c != 92) return Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                            input = input.step();
                            step = 3;
                        }
                    } else if (input.isDone()) {
                        return Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                    }
                }
                if (step != 3) break block15;
                if (!input.isCont()) break;
                c = input.head();
                if (!Http.isEscapeChar(c)) return Parser.error((Diagnostic)Diagnostic.expected((String)"escape character", (Input)input));
                input = input.step();
                commentBuilder.appendCodePoint(c);
                step = 2;
            }
            if (input.isDone()) {
                return Parser.error((Diagnostic)Diagnostic.expected((String)"escape character", (Input)input));
            }
        }
        if (!input.isError()) return new CommentParser(commentBuilder, level, step);
        return Parser.error((Throwable)input.trap());
    }

    static Parser<String> parse(Input input) {
        return CommentParser.parse(input, null, 0, 1);
    }
}

