/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import java.util.Iterator;
import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.http.Http;
import swim.http.HttpException;

final class CommentsWriter
extends Writer<Object, Object> {
    final Iterator<String> comments;
    final String comment;
    final int index;
    final int escape;
    final int step;

    CommentsWriter(Iterator<String> comments, String comment, int index, int escape, int step) {
        this.comments = comments;
        this.comment = comment;
        this.index = index;
        this.escape = escape;
        this.step = step;
    }

    CommentsWriter(Iterator<String> comments) {
        this(comments, null, 0, 0, 1);
    }

    public Writer<Object, Object> pull(Output<?> output) {
        return CommentsWriter.write(output, this.comments, this.comment, this.index, this.escape, this.step);
    }

    static Writer<Object, Object> write(Output<?> output, Iterator<String> comments, String comment, int index, int escape, int step) {
        while (true) {
            if (step == 1) {
                if (!comments.hasNext()) {
                    return Writer.done();
                }
                if (output.isCont()) {
                    output = output.write(32);
                    comment = comments.next();
                    index = 0;
                    step = 2;
                }
            }
            if (step == 2 && output.isCont()) {
                output = output.write(40);
                step = 3;
            }
            if (step == 3) {
                int length = comment.length();
                while (index < length && output.isCont()) {
                    int c = comment.codePointAt(index);
                    if (!Http.isCommentChar(c)) {
                        if (Http.isVisibleChar(c)) {
                            output = output.write(92);
                            escape = c;
                            step = 4;
                            break;
                        }
                        return Writer.error((Throwable)new HttpException("invalid comment: " + comment));
                    }
                    output = output.write(c);
                    index = comment.offsetByCodePoints(index, 1);
                }
                if (index == length) {
                    comment = null;
                    index = 0;
                    step = 5;
                }
            }
            if (step == 4 && output.isCont()) {
                output = output.write(escape);
                escape = 0;
                step = 3;
                continue;
            }
            if (step != 5 || !output.isCont()) break;
            output = output.write(41);
            step = 1;
        }
        if (output.isDone()) {
            return Writer.error((Throwable)new WriterException("truncated"));
        }
        if (output.isError()) {
            return Writer.error((Throwable)output.trap());
        }
        return new CommentsWriter(comments, comment, index, escape, step);
    }

    public static Writer<Object, Object> write(Output<?> output, Iterator<String> comments) {
        return CommentsWriter.write(output, comments, null, 0, 0, 1);
    }
}

