/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Debug;
import swim.codec.Output;
import swim.codec.Writer;
import swim.http.CookieWriter;
import swim.http.Http;
import swim.http.HttpPart;
import swim.http.HttpWriter;
import swim.util.Murmur3;

public class Cookie
extends HttpPart
implements Debug {
    final String name;
    final String value;
    private static int hashSeed;

    Cookie(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("Cookie").write(46).write("create").write(40).debug((Object)this.name);
        if (this.value != null) {
            output = output.write(", ").debug((Object)this.value);
        }
        output = output.write(41);
        return output;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Cookie) {
            Cookie that = (Cookie)other;
            return this.name.equals(that.name) && this.value.equals(that.value);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(Cookie.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.name.hashCode()), (int)this.value.hashCode()));
    }

    @Override
    public Writer<?, ?> httpWriter(HttpWriter http) {
        return new CookieWriter(http, this.name, this.value);
    }

    @Override
    public Writer<?, ?> writeHttp(Output<?> output, HttpWriter http) {
        return CookieWriter.write(output, http, this.name, this.value);
    }

    public static Cookie create(String name, String value) {
        return new Cookie(name, value);
    }

    public static Cookie create(String name) {
        return new Cookie(name, "");
    }

    public static Cookie parse(String string) {
        return Http.standardParser().parseCookieString(string);
    }
}

