/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.http.Cookie;
import swim.http.Http;
import swim.http.HttpParser;

final class CookieParser
extends Parser<Cookie> {
    final HttpParser http;
    final StringBuilder nameBuilder;
    final StringBuilder valueBuilder;
    final int step;

    CookieParser(HttpParser http, StringBuilder nameBuilder, StringBuilder valueBuilder, int step) {
        this.http = http;
        this.nameBuilder = nameBuilder;
        this.valueBuilder = valueBuilder;
        this.step = step;
    }

    CookieParser(HttpParser http) {
        this(http, null, null, 1);
    }

    public Parser<Cookie> feed(Input input) {
        return CookieParser.parse(input, this.http, this.nameBuilder, this.valueBuilder, this.step);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Parser<Cookie> parse(Input input, HttpParser http, StringBuilder nameBuilder, StringBuilder valueBuilder, int step) {
        int c = 0;
        if (step == 1) {
            if (input.isCont()) {
                c = input.head();
                if (!Http.isVisibleChar(c) || c == 61 || c == 59) return Parser.error((Diagnostic)Diagnostic.expected((String)"cookie name", (Input)input));
                input = input.step();
                if (nameBuilder == null) {
                    nameBuilder = new StringBuilder();
                }
                nameBuilder.appendCodePoint(c);
                step = 2;
            } else if (input.isDone()) {
                return Parser.error((Diagnostic)Diagnostic.expected((String)"cookie name", (Input)input));
            }
        }
        if (step == 2) {
            while (input.isCont() && Http.isVisibleChar(c = input.head()) && c != 61 && c != 59) {
                input = input.step();
                nameBuilder.appendCodePoint(c);
            }
            if (!input.isEmpty()) {
                step = 3;
            } else if (input.isDone() || !Http.isVisibleChar(c)) {
                return Parser.done((Object)http.cookie(nameBuilder.toString(), ""));
            }
        }
        if (step == 3) {
            if (input.isCont() && c == 61) {
                input = input.step();
                valueBuilder = new StringBuilder();
                step = 4;
            } else if (!input.isEmpty() || !Http.isVisibleChar(c)) {
                return Parser.done((Object)http.cookie(nameBuilder.toString(), ""));
            }
        }
        if (step != 4) return new CookieParser(http, nameBuilder, valueBuilder, step);
        while (input.isCont() && Http.isVisibleChar(c = input.head()) && c != 61 && c != 59) {
            input = input.step();
            valueBuilder.appendCodePoint(c);
        }
        if (!input.isDone() && c != 59 && Http.isVisibleChar(c)) return new CookieParser(http, nameBuilder, valueBuilder, step);
        return Parser.done((Object)http.cookie(nameBuilder.toString(), valueBuilder.toString()));
    }

    static Parser<Cookie> parse(Input input, HttpParser http) {
        return CookieParser.parse(input, http, null, null, 1);
    }
}

