/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.http.HttpWriter;

final class HttpCharsetWriter
extends Writer<Object, Object> {
    final HttpWriter http;
    final String name;
    final float weight;
    final Writer<?, ?> part;
    final int step;

    HttpCharsetWriter(HttpWriter http, String name, float weight, Writer<?, ?> part, int step) {
        this.http = http;
        this.name = name;
        this.weight = weight;
        this.part = part;
        this.step = step;
    }

    HttpCharsetWriter(HttpWriter http, String name, float weight) {
        this(http, name, weight, null, 1);
    }

    public Writer<Object, Object> pull(Output<?> output) {
        return HttpCharsetWriter.write(output, this.http, this.name, this.weight, this.part, this.step);
    }

    static Writer<Object, Object> write(Output<?> output, HttpWriter http, String name, float weight, Writer<?, ?> part, int step) {
        if (step == 1) {
            if ((part = part == null ? http.writeToken(output, name) : part.pull(output)).isDone()) {
                part = null;
                if (weight == 1.0f) {
                    return Writer.done();
                }
                step = 2;
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 2) {
            if ((part = part == null ? http.writeQValue(output, weight) : part.pull(output)).isDone()) {
                return Writer.done();
            }
            if (part.isError()) {
                return part.asError();
            }
        }
        if (output.isDone()) {
            return Writer.error((Throwable)new WriterException("truncated"));
        }
        if (output.isError()) {
            return Writer.error((Throwable)output.trap());
        }
        return new HttpCharsetWriter(http, name, weight, part, step);
    }

    static Writer<Object, Object> write(Output<?> output, HttpWriter http, String name, float weight) {
        return HttpCharsetWriter.write(output, http, name, weight, null, 1);
    }
}

