/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import java.util.Iterator;
import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.http.HttpHeader;
import swim.http.HttpWriter;

final class HttpChunkTrailerWriter
extends Writer<Object, Object> {
    final HttpWriter http;
    final Iterator<HttpHeader> headers;
    final Writer<?, ?> part;
    final int step;

    HttpChunkTrailerWriter(HttpWriter http, Iterator<HttpHeader> headers, Writer<?, ?> part, int step) {
        this.http = http;
        this.headers = headers;
        this.part = part;
        this.step = step;
    }

    HttpChunkTrailerWriter(HttpWriter http, Iterator<HttpHeader> headers) {
        this(http, headers, null, 1);
    }

    public Writer<Object, Object> pull(Output<?> output) {
        return HttpChunkTrailerWriter.write(output, this.http, this.headers, this.part, this.step);
    }

    static Writer<Object, Object> write(Output<?> output, HttpWriter http, Iterator<HttpHeader> headers, Writer<?, ?> part, int step) {
        while (true) {
            if (step == 1) {
                if (part == null) {
                    if (!headers.hasNext()) {
                        step = 4;
                        break;
                    }
                    part = headers.next().writeHttp(output, http);
                } else {
                    part = part.pull(output);
                }
                if (part.isDone()) {
                    part = null;
                    step = 2;
                } else if (part.isError()) {
                    return part.asError();
                }
            }
            if (step == 2 && output.isCont()) {
                output = output.write(13);
                step = 3;
            }
            if (step != 3 || !output.isCont()) break;
            output = output.write(10);
            step = 1;
        }
        if (step == 4 && output.isCont()) {
            output = output.write(13);
            step = 5;
        }
        if (step == 5 && output.isCont()) {
            output = output.write(10);
            return Writer.done();
        }
        if (output.isDone()) {
            return Writer.error((Throwable)new WriterException("truncated"));
        }
        if (output.isError()) {
            return Writer.error((Throwable)output.trap());
        }
        return new HttpChunkTrailerWriter(http, headers, part, step);
    }

    static Writer<Object, Object> write(Output<?> output, HttpWriter http, Iterator<HttpHeader> headers) {
        return HttpChunkTrailerWriter.write(output, http, headers, null, 1);
    }
}

