/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.Utf8;
import swim.codec.Writer;
import swim.http.Http;
import swim.http.HttpPart;
import swim.http.HttpWriter;

public abstract class HttpHeader
extends HttpPart
implements Comparable<HttpHeader>,
Debug {
    public boolean isBlank() {
        return false;
    }

    public abstract String lowerCaseName();

    public abstract String name();

    public String value() {
        Output output = Utf8.decodedString();
        this.writeHeaderValue(output, Http.standardWriter()).bind();
        return (String)output.bind();
    }

    @Override
    public Writer<?, ?> httpWriter(HttpWriter http) {
        return http.headerWriter(this);
    }

    @Override
    public Writer<?, ?> writeHttp(Output<?> output, HttpWriter http) {
        return http.writeHeader(output, this);
    }

    public abstract Writer<?, ?> writeHeaderValue(Output<?> var1, HttpWriter var2);

    @Override
    public int compareTo(HttpHeader that) {
        int order = this.name().compareTo(that.name());
        if (order == 0) {
            order = this.value().compareTo(that.value());
        }
        return order;
    }

    public abstract <T> Output<T> debug(Output<T> var1);

    public String toString() {
        return Format.debug((Object)this);
    }

    public static HttpHeader parseHttp(String string) {
        return Http.standardParser().parseHeaderString(string);
    }
}

