/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.collections.HashTrieMap;
import swim.http.Http;
import swim.http.HttpParser;
import swim.http.MediaRange;

final class MediaRangeParser
extends Parser<MediaRange> {
    final HttpParser http;
    final StringBuilder typeBuilder;
    final StringBuilder subtypeBuilder;
    final Parser<Float> weightParser;
    final Parser<HashTrieMap<String, String>> paramsParser;
    final int step;

    MediaRangeParser(HttpParser http, StringBuilder typeBuilder, StringBuilder subtypeBuilder, Parser<Float> weightParser, Parser<HashTrieMap<String, String>> paramsParser, int step) {
        this.http = http;
        this.typeBuilder = typeBuilder;
        this.subtypeBuilder = subtypeBuilder;
        this.weightParser = weightParser;
        this.paramsParser = paramsParser;
        this.step = step;
    }

    MediaRangeParser(HttpParser http) {
        this(http, null, null, null, null, 1);
    }

    public Parser<MediaRange> feed(Input input) {
        return MediaRangeParser.parse(input, this.http, this.typeBuilder, this.subtypeBuilder, this.weightParser, this.paramsParser, this.step);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Parser<MediaRange> parse(Input input, HttpParser http, StringBuilder typeBuilder, StringBuilder subtypeBuilder, Parser<Float> weightParser, Parser<HashTrieMap<String, String>> paramsParser, int step) {
        int c = 0;
        if (step == 1) {
            if (input.isCont()) {
                c = input.head();
                if (!Http.isTokenChar(c)) return Parser.error((Diagnostic)Diagnostic.expected((String)"media type", (Input)input));
                input = input.step();
                if (typeBuilder == null) {
                    typeBuilder = new StringBuilder();
                }
                typeBuilder.appendCodePoint(c);
                step = 2;
            } else if (input.isDone()) {
                return Parser.error((Diagnostic)Diagnostic.expected((String)"media type", (Input)input));
            }
        }
        if (step == 2) {
            while (input.isCont() && Http.isTokenChar(c = input.head())) {
                input = input.step();
                typeBuilder.appendCodePoint(c);
            }
            if (input.isCont() && c == 47) {
                input = input.step();
                step = 3;
            } else if (!input.isEmpty()) {
                return Parser.error((Diagnostic)Diagnostic.expected((int)47, (Input)input));
            }
        }
        if (step == 3) {
            if (input.isCont()) {
                c = input.head();
                if (!Http.isTokenChar(c)) return Parser.error((Diagnostic)Diagnostic.expected((String)"media subtype", (Input)input));
                input = input.step();
                if (subtypeBuilder == null) {
                    subtypeBuilder = new StringBuilder();
                }
                subtypeBuilder.appendCodePoint(c);
                step = 4;
            } else if (input.isDone()) {
                return Parser.error((Diagnostic)Diagnostic.expected((String)"media subtype", (Input)input));
            }
        }
        if (step == 4) {
            while (input.isCont() && Http.isTokenChar(c = input.head())) {
                input = input.step();
                subtypeBuilder.appendCodePoint(c);
            }
            if (!input.isEmpty()) {
                step = 5;
            }
        }
        if (step == 5) {
            while (input.isCont() && Http.isSpace(c = input.head())) {
                input = input.step();
            }
            if (input.isCont() && c == 59) {
                input = input.step();
                step = 6;
            } else if (!input.isEmpty()) {
                return Parser.done((Object)http.mediaRange(typeBuilder.toString(), subtypeBuilder.toString(), 1.0f, (HashTrieMap<String, String>)HashTrieMap.empty()));
            }
        }
        if (step == 6) {
            while (input.isCont() && Http.isSpace(c = input.head())) {
                input = input.step();
            }
            if (input.isCont()) {
                if (c == 113) {
                    input = input.step();
                    step = 7;
                } else {
                    paramsParser = http.parseParamMapRest(input);
                    step = 9;
                }
            } else if (input.isDone()) {
                return Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
            }
        }
        if (step == 7) {
            if (input.isCont()) {
                c = input.head();
                if (c == 61) {
                    weightParser = http.parseQValueRest(input);
                    step = 8;
                } else {
                    paramsParser = http.parseParamMapRest(input, new StringBuilder().append('q'));
                    step = 9;
                }
            } else if (input.isDone()) {
                return Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
            }
        }
        if (step == 8) {
            if ((weightParser = weightParser.feed(input)).isDone()) {
                step = 9;
            } else if (weightParser.isError()) {
                return weightParser.asError();
            }
        }
        if (step == 9) {
            if ((paramsParser = paramsParser == null ? http.parseParamMap(input) : paramsParser.feed(input)).isDone()) {
                Float qvalue = weightParser != null ? (Float)weightParser.bind() : null;
                float q = qvalue != null ? qvalue.floatValue() : 1.0f;
                return Parser.done((Object)http.mediaRange(typeBuilder.toString(), subtypeBuilder.toString(), q, (HashTrieMap<String, String>)((HashTrieMap)paramsParser.bind())));
            }
            if (paramsParser.isError()) {
                return paramsParser.asError();
            }
        }
        if (!input.isError()) return new MediaRangeParser(http, typeBuilder, subtypeBuilder, weightParser, paramsParser, step);
        return Parser.error((Throwable)input.trap());
    }

    static Parser<MediaRange> parse(Input input, HttpParser http) {
        return MediaRangeParser.parse(input, http, null, null, null, null, 1);
    }
}

