/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.collections.HashTrieMap;
import swim.http.Http;
import swim.http.HttpParser;
import swim.http.MediaType;

final class MediaTypeParser
extends Parser<MediaType> {
    final HttpParser http;
    final StringBuilder typeBuilder;
    final StringBuilder subtypeBuilder;
    final Parser<HashTrieMap<String, String>> paramsParser;
    final int step;

    MediaTypeParser(HttpParser http, StringBuilder typeBuilder, StringBuilder subtypeBuilder, Parser<HashTrieMap<String, String>> paramsParser, int step) {
        this.http = http;
        this.typeBuilder = typeBuilder;
        this.subtypeBuilder = subtypeBuilder;
        this.paramsParser = paramsParser;
        this.step = step;
    }

    MediaTypeParser(HttpParser http) {
        this(http, null, null, null, 1);
    }

    public Parser<MediaType> feed(Input input) {
        return MediaTypeParser.parse(input, this.http, this.typeBuilder, this.subtypeBuilder, this.paramsParser, this.step);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Parser<MediaType> parse(Input input, HttpParser http, StringBuilder typeBuilder, StringBuilder subtypeBuilder, Parser<HashTrieMap<String, String>> paramsParser2222, int step) {
        int c = 0;
        if (step == 1) {
            if (input.isCont()) {
                c = input.head();
                if (!Http.isTokenChar(c)) return Parser.error((Diagnostic)Diagnostic.expected((String)"media type", (Input)input));
                input = input.step();
                if (typeBuilder == null) {
                    typeBuilder = new StringBuilder();
                }
                typeBuilder.appendCodePoint(c);
                step = 2;
            } else if (input.isDone()) {
                return Parser.error((Diagnostic)Diagnostic.expected((String)"media type", (Input)input));
            }
        }
        if (step == 2) {
            while (input.isCont() && Http.isTokenChar(c = input.head())) {
                input = input.step();
                typeBuilder.appendCodePoint(c);
            }
            if (input.isCont() && c == 47) {
                input = input.step();
                step = 3;
            } else if (!input.isEmpty()) {
                return Parser.error((Diagnostic)Diagnostic.expected((int)47, (Input)input));
            }
        }
        if (step == 3) {
            if (input.isCont()) {
                c = input.head();
                if (!Http.isTokenChar(c)) return Parser.error((Diagnostic)Diagnostic.expected((String)"media subtype", (Input)input));
                input = input.step();
                if (subtypeBuilder == null) {
                    subtypeBuilder = new StringBuilder();
                }
                subtypeBuilder.appendCodePoint(c);
                step = 4;
            } else if (input.isDone()) {
                return Parser.error((Diagnostic)Diagnostic.expected((String)"media subtype", (Input)input));
            }
        }
        if (step == 4) {
            while (input.isCont() && Http.isTokenChar(c = input.head())) {
                input = input.step();
                subtypeBuilder.appendCodePoint(c);
            }
            if (!input.isEmpty()) {
                step = 5;
            }
        }
        if (step == 5) {
            void paramsParser2222;
            if (paramsParser2222 == null) {
                Parser<HashTrieMap<String, String>> paramsParser2222 = http.parseParamMap(input);
            } else {
                Object paramsParser2222;
                Parser paramsParser2222 = paramsParser2222.feed(input);
            }
            if (paramsParser2222.isDone()) {
                return Parser.done((Object)http.mediaType(typeBuilder.toString(), subtypeBuilder.toString(), (HashTrieMap<String, String>)((HashTrieMap)paramsParser2222.bind())));
            }
            if (paramsParser2222.isError()) {
                return paramsParser2222.asError();
            }
        }
        if (!input.isError()) void paramsParser2222;
        return new MediaTypeParser(http, typeBuilder, subtypeBuilder, (Parser<HashTrieMap<String, String>>)paramsParser2222, step);
        return Parser.error((Throwable)input.trap());
    }

    static Parser<MediaType> parse(Input input, HttpParser http) {
        return MediaTypeParser.parse(input, http, null, null, null, 1);
    }
}

