/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import java.util.Iterator;
import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.http.HttpWriter;

final class ProductWriter
extends Writer<Object, Object> {
    final HttpWriter http;
    final String name;
    final String version;
    final Iterator<String> comments;
    final Writer<?, ?> part;
    final int step;

    ProductWriter(HttpWriter http, String name, String version, Iterator<String> comments, Writer<?, ?> part, int step) {
        this.http = http;
        this.name = name;
        this.version = version;
        this.comments = comments;
        this.part = part;
        this.step = step;
    }

    ProductWriter(HttpWriter http, String name, String version, Iterator<String> comments) {
        this(http, name, version, comments, null, 1);
    }

    public Writer<Object, Object> pull(Output<?> output) {
        return ProductWriter.write(output, this.http, this.name, this.version, this.comments, this.part, this.step);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Writer<Object, Object> write(Output<?> output, HttpWriter http, String name, String version, Iterator<String> comments, Writer<?, ?> part, int step) {
        if (step == 1) {
            if ((part = part == null ? http.writeToken(output, name) : part.pull(output)).isDone()) {
                part = null;
                if (version != null) {
                    step = 2;
                } else {
                    if (!comments.hasNext()) return Writer.done();
                    step = 4;
                }
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 2 && output.isCont()) {
            output = output.write(47);
            step = 3;
        }
        if (step == 3) {
            if ((part = part == null ? http.writeToken(output, version) : part.pull(output)).isDone()) {
                part = null;
                if (!comments.hasNext()) return Writer.done();
                step = 4;
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 4) {
            if ((part = part == null ? http.writeComments(output, comments) : part.pull(output)).isDone()) {
                return Writer.done();
            }
            if (part.isError()) {
                return part.asError();
            }
        }
        if (output.isDone()) {
            return Writer.error((Throwable)new WriterException("truncated"));
        }
        if (!output.isError()) return new ProductWriter(http, name, version, comments, part, step);
        return Writer.error((Throwable)output.trap());
    }

    static Writer<Object, Object> write(Output<?> output, HttpWriter http, String name, String version, Iterator<String> comments) {
        return ProductWriter.write(output, http, name, version, comments, null, 1);
    }
}

