/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Writer;
import swim.collections.FingerTrieSeq;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.LanguageRange;
import swim.http.header.AcceptLanguageHeaderParser;
import swim.util.Builder;
import swim.util.Murmur3;

public final class AcceptLanguageHeader
extends HttpHeader {
    final FingerTrieSeq<LanguageRange> languages;
    private static int hashSeed;

    AcceptLanguageHeader(FingerTrieSeq<LanguageRange> languages) {
        this.languages = languages;
    }

    @Override
    public boolean isBlank() {
        return this.languages.isEmpty();
    }

    @Override
    public String lowerCaseName() {
        return "accept-language";
    }

    @Override
    public String name() {
        return "Accept-Language";
    }

    public FingerTrieSeq<LanguageRange> languages() {
        return this.languages;
    }

    @Override
    public Writer<?, ?> writeHeaderValue(Output<?> output, HttpWriter http) {
        return http.writeParamList(output, this.languages.iterator());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof AcceptLanguageHeader) {
            AcceptLanguageHeader that = (AcceptLanguageHeader)other;
            return this.languages.equals(that.languages);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(AcceptLanguageHeader.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.languages.hashCode()));
    }

    @Override
    public <T> Output<T> debug(Output<T> output) {
        output = output.write("AcceptLanguageHeader").write(46).write("create").write(40);
        int n = this.languages.size();
        if (n > 0) {
            output = output.debug(this.languages.head());
            for (int i = 1; i < n; ++i) {
                output = output.write(", ").debug(this.languages.get(i));
            }
        }
        output = output.write(41);
        return output;
    }

    public static AcceptLanguageHeader empty() {
        return new AcceptLanguageHeader((FingerTrieSeq<LanguageRange>)FingerTrieSeq.empty());
    }

    public static AcceptLanguageHeader create(FingerTrieSeq<LanguageRange> languages) {
        return new AcceptLanguageHeader(languages);
    }

    public static AcceptLanguageHeader create(LanguageRange ... languages) {
        return new AcceptLanguageHeader((FingerTrieSeq<LanguageRange>)FingerTrieSeq.of((Object[])languages));
    }

    public static AcceptLanguageHeader create(String ... languageStrings) {
        Builder languages = FingerTrieSeq.builder();
        int n = languageStrings.length;
        for (int i = 0; i < n; ++i) {
            languages.add((Object)LanguageRange.parse(languageStrings[i]));
        }
        return new AcceptLanguageHeader((FingerTrieSeq<LanguageRange>)((FingerTrieSeq)languages.bind()));
    }

    public static Parser<AcceptLanguageHeader> parseHeaderValue(Input input, HttpParser http) {
        return AcceptLanguageHeaderParser.parse(input, http);
    }
}

