/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.collections.FingerTrieSeq;
import swim.http.HttpParser;
import swim.http.header.ConnectionHeader;

final class ConnectionHeaderParser
extends Parser<ConnectionHeader> {
    final HttpParser http;
    final Parser<FingerTrieSeq<String>> optionsParser;

    ConnectionHeaderParser(HttpParser http, Parser<FingerTrieSeq<String>> optionsParser) {
        this.http = http;
        this.optionsParser = optionsParser;
    }

    ConnectionHeaderParser(HttpParser http) {
        this(http, null);
    }

    public Parser<ConnectionHeader> feed(Input input) {
        return ConnectionHeaderParser.parse(input, this.http, this.optionsParser);
    }

    static Parser<ConnectionHeader> parse(Input input, HttpParser http, Parser<FingerTrieSeq<String>> optionsParser) {
        if ((optionsParser = optionsParser == null ? http.parseTokenList(input) : optionsParser.feed(input)).isDone()) {
            FingerTrieSeq tokens = (FingerTrieSeq)optionsParser.bind();
            if (!tokens.isEmpty()) {
                return Parser.done((Object)ConnectionHeader.create((FingerTrieSeq<String>)tokens));
            }
            return Parser.error((Diagnostic)Diagnostic.expected((String)"connection option", (Input)input));
        }
        if (optionsParser.isError()) {
            return optionsParser.asError();
        }
        if (input.isError()) {
            return Parser.error((Throwable)input.trap());
        }
        return new ConnectionHeaderParser(http, (Parser<FingerTrieSeq<String>>)optionsParser);
    }

    static Parser<ConnectionHeader> parse(Input input, HttpParser http) {
        return ConnectionHeaderParser.parse(input, http, null);
    }
}

