/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import java.util.Map;
import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Writer;
import swim.collections.HashTrieMap;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.MediaType;
import swim.http.header.ContentTypeHeaderParser;
import swim.util.Murmur3;

public final class ContentTypeHeader
extends HttpHeader {
    final MediaType mediaType;
    private static int hashSeed;

    ContentTypeHeader(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    @Override
    public String lowerCaseName() {
        return "content-type";
    }

    @Override
    public String name() {
        return "Content-Type";
    }

    public MediaType mediaType() {
        return this.mediaType;
    }

    public String type() {
        return this.mediaType.type();
    }

    public String subtype() {
        return this.mediaType.subtype();
    }

    public HashTrieMap<String, String> params() {
        return this.mediaType.params();
    }

    public String getParam(String key) {
        return this.mediaType.getParam(key);
    }

    public ContentTypeHeader param(String key, String value) {
        return ContentTypeHeader.create(this.mediaType.param(key, value));
    }

    @Override
    public Writer<?, ?> writeHeaderValue(Output<?> output, HttpWriter http) {
        return this.mediaType.writeHttp(output, http);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ContentTypeHeader) {
            ContentTypeHeader that = (ContentTypeHeader)other;
            return this.mediaType.equals(that.mediaType);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(ContentTypeHeader.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.mediaType.hashCode()));
    }

    @Override
    public <T> Output<T> debug(Output<T> output) {
        output = output.write("ContentTypeHeader").write(46).write("create").write(40).debug((Object)this.mediaType.type()).write(", ").write(this.mediaType.subtype()).write(41);
        for (Map.Entry param : this.mediaType.params()) {
            output = output.write(46).write("param").write(40).debug(param.getKey()).write(", ").debug(param.getValue()).write(41);
        }
        return output;
    }

    public static ContentTypeHeader create(MediaType mediaType) {
        return new ContentTypeHeader(mediaType);
    }

    public static ContentTypeHeader create(String type, String subtype, HashTrieMap<String, String> params) {
        return ContentTypeHeader.create(MediaType.create(type, subtype, params));
    }

    public static ContentTypeHeader create(String type, String subtype) {
        return ContentTypeHeader.create(MediaType.create(type, subtype));
    }

    public static ContentTypeHeader create(String mediaType) {
        return ContentTypeHeader.create(MediaType.parse(mediaType));
    }

    public static Parser<ContentTypeHeader> parseHeaderValue(Input input, HttpParser http) {
        return ContentTypeHeaderParser.parse(input, http);
    }
}

