/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import java.util.Arrays;
import swim.codec.Base64;
import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Unicode;
import swim.codec.Writer;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.header.SecWebSocketAcceptHeaderParser;
import swim.util.Murmur3;

public final class SecWebSocketAcceptHeader
extends HttpHeader {
    final byte[] digest;
    private static int hashSeed;

    SecWebSocketAcceptHeader(byte[] digest) {
        this.digest = digest;
    }

    @Override
    public String lowerCaseName() {
        return "sec-websocket-accept";
    }

    @Override
    public String name() {
        return "Sec-WebSocket-Accept";
    }

    public byte[] digest() {
        return this.digest;
    }

    @Override
    public Writer<?, ?> writeHeaderValue(Output<?> output, HttpWriter http) {
        return Base64.standard().writeByteArray(output, this.digest);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof SecWebSocketAcceptHeader) {
            SecWebSocketAcceptHeader that = (SecWebSocketAcceptHeader)other;
            return Arrays.equals(this.digest, that.digest);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(SecWebSocketAcceptHeader.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)Arrays.hashCode(this.digest)));
    }

    @Override
    public <T> Output<T> debug(Output<T> output) {
        output = output.write("SecWebSocketAcceptHeader").write(46).write("create").write(40).write(34);
        Base64.standard().writeByteArray(output, this.digest).bind();
        output = output.write(34).write(41);
        return output;
    }

    public static SecWebSocketAcceptHeader create(byte[] digest) {
        return new SecWebSocketAcceptHeader(digest);
    }

    public static SecWebSocketAcceptHeader create(String digestString) {
        Input input = Unicode.stringInput((String)digestString);
        Parser parser = Base64.standard().parseByteArray(input);
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        }
        return new SecWebSocketAcceptHeader((byte[])parser.bind());
    }

    public static Parser<SecWebSocketAcceptHeader> parseHeaderValue(Input input, HttpParser http) {
        return SecWebSocketAcceptHeaderParser.parse(input);
    }
}

