/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Base64;
import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.http.header.SecWebSocketKeyHeader;

final class SecWebSocketKeyHeaderParser
extends Parser<SecWebSocketKeyHeader> {
    final Parser<byte[]> keyParser;

    SecWebSocketKeyHeaderParser(Parser<byte[]> keyParser) {
        this.keyParser = keyParser;
    }

    SecWebSocketKeyHeaderParser() {
        this(null);
    }

    public Parser<SecWebSocketKeyHeader> feed(Input input) {
        return SecWebSocketKeyHeaderParser.parse(input, this.keyParser);
    }

    static Parser<SecWebSocketKeyHeader> parse(Input input, Parser<byte[]> keyParser) {
        if ((keyParser = keyParser == null ? Base64.standard().parseByteArray(input) : keyParser.feed(input)).isDone()) {
            byte[] data = (byte[])keyParser.bind();
            if (data.length != 0) {
                return Parser.done((Object)SecWebSocketKeyHeader.create(data));
            }
            return Parser.error((Diagnostic)Diagnostic.expected((String)"base64 key", (Input)input));
        }
        if (keyParser.isError()) {
            return keyParser.asError();
        }
        if (input.isError()) {
            return Parser.error((Throwable)input.trap());
        }
        return new SecWebSocketKeyHeaderParser((Parser<byte[]>)keyParser);
    }

    static Parser<SecWebSocketKeyHeader> parse(Input input) {
        return SecWebSocketKeyHeaderParser.parse(input, null);
    }
}

