/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import java.util.Map;
import swim.codec.Output;
import swim.codec.Writer;
import swim.collections.HashTrieMap;
import swim.http.Cookie;
import swim.http.HttpHeader;
import swim.http.HttpWriter;
import swim.http.header.SetCookieHeaderWriter;
import swim.util.Murmur3;

public class SetCookieHeader
extends HttpHeader {
    final Cookie cookie;
    HashTrieMap<String, String> params;
    private static int hashSeed;

    SetCookieHeader(Cookie cookie, HashTrieMap<String, String> params) {
        this.cookie = cookie;
        this.params = params;
    }

    @Override
    public boolean isBlank() {
        return this.cookie.getName().isEmpty();
    }

    @Override
    public String lowerCaseName() {
        return "set-cookie";
    }

    @Override
    public String name() {
        return "Set-Cookie";
    }

    @Override
    public Writer<?, ?> writeHeaderValue(Output<?> output, HttpWriter http) {
        return SetCookieHeaderWriter.write(output, http, this.cookie, this.params);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof SetCookieHeader) {
            SetCookieHeader that = (SetCookieHeader)other;
            return this.cookie.equals(that.cookie) && this.params.equals(that.params);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(SetCookieHeader.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.cookie.hashCode()), (int)this.params.hashCode()));
    }

    @Override
    public <T> Output<T> debug(Output<T> output) {
        output = output.write("SetCookieHeader").write(46).write("create").write(40).debug((Object)this.cookie);
        for (Map.Entry param : this.params) {
            output = output.write(46).write("param").write(40).debug(param.getKey());
            if (!((String)param.getValue()).isEmpty()) {
                output.write(", ").debug(param.getValue());
            }
            output.write(41);
        }
        output.write(41);
        return output;
    }

    public static SetCookieHeader create(Cookie cookie) {
        return new SetCookieHeader(cookie, (HashTrieMap<String, String>)HashTrieMap.empty());
    }

    public static SetCookieHeader create(String name, String value) {
        return new SetCookieHeader(Cookie.create(name, value), (HashTrieMap<String, String>)HashTrieMap.empty());
    }

    public static SetCookieHeader create(String name) {
        return new SetCookieHeader(Cookie.create(name), (HashTrieMap<String, String>)HashTrieMap.empty());
    }

    public void expire() {
        this.setMaxAge(0L);
    }

    public void setSecure() {
        this.params = this.params.updated((Object)"Secure", (Object)"");
    }

    public void unsetSecure() {
        this.params = this.params.removed((Object)"Secure");
    }

    public void setHttpOnly() {
        this.params = this.params.updated((Object)"HttpOnly", (Object)"");
    }

    public void unsetHttpOnly() {
        this.params = this.params.removed((Object)"HttpOnly");
    }

    public void setMaxAge(long maxAge) {
        this.params = this.params.updated((Object)"Max-Age", (Object)Long.toString(maxAge));
    }

    public void unsetMaxAge() {
        this.params = this.params.removed((Object)"Max-Age");
    }

    public void setDomain(String domain) {
        this.params = this.params.updated((Object)"Domain", (Object)domain);
    }

    public void unsetDomain() {
        this.params = this.params.removed((Object)"Domain");
    }

    public void setPath(String path) {
        this.params = this.params.updated((Object)"Path", (Object)path);
    }

    public void unsetPath() {
        this.params = this.params.removed((Object)"Path");
    }

    public void setSameSite(SameSite sameSite) {
        this.params = this.params.updated((Object)"SameSite", (Object)sameSite.name());
    }

    public void unsetSameSite() {
        this.params = this.params.removed((Object)"SameSite");
    }

    public static enum SameSite {
        Strict,
        Lax,
        None;

    }
}

