/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.Writer;
import swim.http.Http;
import swim.http.HttpPart;
import swim.http.HttpWriter;
import swim.util.Murmur3;

public final class ChunkExtension
extends HttpPart
implements Debug {
    final String name;
    final String value;
    private static int hashSeed;

    ChunkExtension(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String name() {
        return this.name;
    }

    public String value() {
        return this.value;
    }

    @Override
    public Writer<?, ?> httpWriter(HttpWriter http) {
        return http.chunkExtensionWriter(this.name, this.value);
    }

    @Override
    public Writer<?, ?> writeHttp(Output<?> output, HttpWriter http) {
        return http.writeChunkExtension(output, this.name, this.value);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ChunkExtension) {
            ChunkExtension that = (ChunkExtension)other;
            return this.name.equals(that.name) && this.value.equals(that.value);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(ChunkExtension.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.name.hashCode()), (int)this.value.hashCode()));
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("ChunkExtension").write(46).write("create").write(40).debug((Object)this.name).write(", ").write(this.value).write(41);
        return output;
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static ChunkExtension create(String name, String value) {
        return new ChunkExtension(name, value);
    }

    public static ChunkExtension create(String name) {
        return new ChunkExtension(name, "");
    }

    public static ChunkExtension parseHttp(String string) {
        return Http.standardParser().parseChunkExtensionString(string);
    }
}

