/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.http.HttpWriter;

final class CookieWriter
extends Writer<Object, Object> {
    final HttpWriter http;
    final String name;
    final String value;
    final Writer<?, ?> part;
    final int step;

    CookieWriter(HttpWriter http, String name, String value, Writer<?, ?> part, int step) {
        this.http = http;
        this.name = name;
        this.value = value;
        this.part = part;
        this.step = step;
    }

    CookieWriter(HttpWriter http, String name, String value) {
        this(http, name, value, null, 1);
    }

    public Writer<Object, Object> pull(Output<?> output) {
        return CookieWriter.write(output, this.http, this.name, this.value, this.part, this.step);
    }

    static Writer<Object, Object> write(Output<?> output, HttpWriter http, String name, String value, Writer<?, ?> part, int step) {
        if (step == 1) {
            if ((part = part == null ? http.writeToken(output, name) : part.pull(output)).isDone()) {
                part = null;
                step = 2;
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 2 && output.isCont()) {
            output = output.write(61);
            if (value.isEmpty()) {
                return Writer.done();
            }
            step = 3;
        }
        if (step == 3) {
            if ((part = part == null ? http.writePhrase(output, value) : part.pull(output)).isDone()) {
                return Writer.done();
            }
            if (part.isError()) {
                return part.asError();
            }
        }
        if (output.isDone()) {
            return Writer.error((Throwable)new WriterException("truncated"));
        }
        if (output.isError()) {
            return Writer.error((Throwable)output.trap());
        }
        return new CookieWriter(http, name, value, part, step);
    }

    static Writer<Object, Object> write(Output<?> output, HttpWriter http, String name, String value) {
        return CookieWriter.write(output, http, name, value, null, 1);
    }
}

