/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import swim.codec.Binary;
import swim.codec.Debug;
import swim.codec.Decoder;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.InputBuffer;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.codec.Utf8;
import swim.collections.FingerTrieSeq;
import swim.http.Http;
import swim.http.HttpHeader;
import swim.http.HttpMessage;
import swim.http.HttpPayload;
import swim.http.HttpWriter;
import swim.http.MediaType;
import swim.http.TransferCoding;
import swim.http.header.ContentLengthHeader;
import swim.http.header.ContentTypeHeader;
import swim.util.Murmur3;

public final class HttpBody<T>
extends HttpPayload<T>
implements Debug {
    final T payloadValue;
    final Encoder<?, ?> payloadEncoder;
    final long contentLength;
    final MediaType mediaType;
    private static int hashSeed;
    private static HttpBody<Object> empty;

    HttpBody(T payloadValue, Encoder<?, ?> payloadEncoder, long contentLength, MediaType mediaType) {
        this.payloadValue = payloadValue;
        this.payloadEncoder = payloadEncoder;
        this.contentLength = contentLength;
        this.mediaType = mediaType;
    }

    @Override
    public boolean isDefined() {
        return this.payloadValue != null;
    }

    @Override
    public T get() {
        return this.payloadValue;
    }

    public Encoder<?, ?> payloadEncoder() {
        return this.payloadEncoder;
    }

    public long contentLength() {
        return this.contentLength;
    }

    @Override
    public MediaType mediaType() {
        return this.mediaType;
    }

    @Override
    public FingerTrieSeq<TransferCoding> transferCodings() {
        return FingerTrieSeq.empty();
    }

    @Override
    public FingerTrieSeq<HttpHeader> headers() {
        FingerTrieSeq headers = FingerTrieSeq.empty();
        if (this.mediaType != null) {
            headers = headers.appended((Object)ContentTypeHeader.create(this.mediaType));
        }
        headers = headers.appended((Object)ContentLengthHeader.create(this.contentLength));
        return headers;
    }

    @Override
    public <T2> Encoder<?, HttpMessage<T2>> httpEncoder(HttpMessage<T2> message, HttpWriter http) {
        return http.bodyEncoder(message, this.payloadEncoder, this.contentLength);
    }

    @Override
    public <T2> Encoder<?, HttpMessage<T2>> encodeHttp(OutputBuffer<?> output, HttpMessage<T2> message, HttpWriter http) {
        return http.encodeBody(output, message, this.payloadEncoder, this.contentLength);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof HttpBody) {
            HttpBody that = (HttpBody)other;
            return (this.payloadValue == null ? that.payloadValue == null : this.payloadValue.equals(that.payloadValue)) && this.contentLength == that.contentLength && (this.mediaType == null ? that.mediaType == null : this.mediaType.equals(that.mediaType));
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(HttpBody.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash(this.payloadValue)), (int)Murmur3.hash((long)this.contentLength)), (int)Murmur3.hash((Object)this.mediaType)));
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("HttpBody").write(46).write("create").write(40);
        if (this.payloadValue != null) {
            output = output.debug(this.payloadValue).write(", ");
        }
        output = output.debug(this.payloadEncoder).write(", ").debug((Object)this.contentLength);
        if (this.mediaType != null) {
            output = output.write(", ").debug((Object)this.mediaType);
        }
        output = output.write(41);
        return output;
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static <T> HttpBody<T> empty() {
        if (empty == null) {
            empty = new HttpBody<Object>(null, Encoder.done(), 0L, null);
        }
        return empty;
    }

    public static <T> HttpBody<T> create(T payloadValue, Encoder<?, ?> payloadEncoder, long contentLength, MediaType mediaType) {
        return new HttpBody<T>(payloadValue, payloadEncoder, contentLength, mediaType);
    }

    public static <T> HttpBody<T> create(T payloadValue, Encoder<?, ?> payloadEncoder, long contentLength) {
        return new HttpBody<T>(payloadValue, payloadEncoder, contentLength, MediaType.applicationOctetStream());
    }

    public static <T> HttpBody<T> create(Encoder<?, ?> payloadEncoder, long contentLength, MediaType mediaType) {
        return new HttpBody<Object>(null, payloadEncoder, contentLength, mediaType);
    }

    public static <T> HttpBody<T> create(Encoder<?, ?> payloadEncoder, long contentLength) {
        return new HttpBody<Object>(null, payloadEncoder, contentLength, MediaType.applicationOctetStream());
    }

    public static <T> HttpBody<T> create(ByteBuffer data, MediaType mediaType) {
        return new HttpBody<Object>(null, (Encoder<?, ?>)Binary.byteBufferWriter((ByteBuffer)data), data.remaining(), mediaType);
    }

    public static <T> HttpBody<T> create(ByteBuffer data) {
        return HttpBody.create(data, MediaType.applicationOctetStream());
    }

    public static HttpBody<String> create(String payloadValue, MediaType mediaType) {
        Output output = Utf8.encodedOutput((Output)Binary.byteBufferOutput((int)payloadValue.length()));
        output = output.write(payloadValue);
        ByteBuffer data = (ByteBuffer)output.bind();
        return new HttpBody<String>(payloadValue, (Encoder<?, ?>)Binary.byteBufferWriter((ByteBuffer)data), data.remaining(), mediaType);
    }

    public static HttpBody<String> create(String payloadValue) {
        return HttpBody.create(payloadValue, MediaType.textPlain());
    }

    public static <T> HttpBody<T> fromFile(String path, MediaType mediaType) throws IOException {
        FileChannel channel = FileChannel.open(Paths.get(path, new String[0]), StandardOpenOption.READ);
        return new HttpBody<Object>(null, Binary.channelEncoder((ReadableByteChannel)channel), channel.size(), mediaType);
    }

    public static <T> HttpBody<T> fromFile(String path) throws IOException {
        return HttpBody.fromFile(path, MediaType.forPath(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> HttpBody<T> fromResource(ClassLoader classLoader, String resource, MediaType mediaType) throws IOException {
        HttpBody<Object> body = null;
        InputStream input = null;
        try {
            input = classLoader.getResourceAsStream(resource);
            if (input != null) {
                ByteBuffer data = (ByteBuffer)Binary.read((InputStream)input, (Decoder)Binary.outputParser((Output)Binary.byteBufferOutput()));
                body = new HttpBody<Object>(null, (Encoder<?, ?>)Binary.byteBufferWriter((ByteBuffer)data), data.remaining(), mediaType);
            }
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {}
        }
        return body;
    }

    public static <T> HttpBody<T> fromResource(ClassLoader classLoader, String resource) throws IOException {
        return HttpBody.fromResource(classLoader, resource, MediaType.forPath(resource));
    }

    public static <T> Decoder<HttpMessage<T>> httpDecoder(HttpMessage<?> message, Decoder<T> payloadDecoder, long contentLength) {
        return Http.standardParser().bodyDecoder(message, payloadDecoder, contentLength);
    }

    public static <T> Decoder<HttpMessage<T>> decodeHttp(InputBuffer input, HttpMessage<?> message, Decoder<T> payloadDecoder, long contentLength) {
        return Http.standardParser().decodeBody(input, message, payloadDecoder, contentLength);
    }
}

