/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.InputBuffer;
import swim.http.HttpMessage;
import swim.http.HttpValue;
import swim.http.MediaType;
import swim.http.header.ContentTypeHeader;

final class HttpBodyDecoder<T>
extends Decoder<HttpMessage<T>> {
    final HttpMessage<?> message;
    final Decoder<T> payloadDecoder;
    final long contentLength;
    final long offset;

    HttpBodyDecoder(HttpMessage<?> message, Decoder<T> payloadDecoder, long contentLength, long offset) {
        this.message = message;
        this.payloadDecoder = payloadDecoder;
        this.contentLength = contentLength;
        this.offset = offset;
    }

    HttpBodyDecoder(HttpMessage<?> message, Decoder<T> payloadDecoder, long contentLength) {
        this(message, payloadDecoder, contentLength, 0L);
    }

    public Decoder<HttpMessage<T>> feed(InputBuffer input) {
        return HttpBodyDecoder.decode(input, this.message, this.payloadDecoder, this.contentLength, this.offset);
    }

    static <T> Decoder<HttpMessage<T>> decode(InputBuffer input, HttpMessage<?> message, Decoder<T> payloadDecoder, long contentLength, long offset) {
        int inputStart = input.index();
        int inputLimit = input.limit();
        int inputRemaining = inputLimit - inputStart;
        long outputRemaining = contentLength - offset;
        boolean inputPart = input.isPart();
        if (outputRemaining <= (long)inputRemaining) {
            input = input.limit(inputStart + (int)outputRemaining).isPart(false);
            payloadDecoder = payloadDecoder.feed(input);
            input = input.limit(inputLimit);
        } else {
            input = input.isPart(true);
            payloadDecoder = payloadDecoder.feed(input);
        }
        input = input.isPart(inputPart);
        int inputEnd = input.index();
        inputRemaining = inputLimit - inputEnd;
        outputRemaining = contentLength - (offset += (long)(inputEnd - inputStart));
        if (payloadDecoder.isDone() && inputRemaining > 0 && outputRemaining > 0L) {
            int inputExcess = (int)Math.min((long)inputRemaining, outputRemaining);
            input = input.index(inputEnd + inputExcess);
            offset += (long)inputExcess;
        }
        if (payloadDecoder.isDone()) {
            if (offset < contentLength) {
                return Decoder.error((Throwable)new DecoderException("buffer underflow"));
            }
            if (offset > contentLength) {
                return Decoder.error((Throwable)new DecoderException("buffer overflow"));
            }
            ContentTypeHeader contentType = message.getHeader(ContentTypeHeader.class);
            MediaType mediaType = contentType != null ? contentType.mediaType() : null;
            HttpValue<Object> payload = HttpValue.create(payloadDecoder.bind(), mediaType);
            return Decoder.done(message.payload(payload));
        }
        if (payloadDecoder.isError()) {
            return payloadDecoder.asError();
        }
        return new HttpBodyDecoder<T>(message, payloadDecoder, contentLength, offset);
    }

    static <T> Decoder<HttpMessage<T>> decode(InputBuffer input, HttpMessage<?> message, Decoder<T> payloadDecoder, long contentLength) {
        return HttpBodyDecoder.decode(input, message, payloadDecoder, contentLength, 0L);
    }
}

