/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Encoder;
import swim.codec.EncoderException;
import swim.codec.OutputBuffer;
import swim.http.HttpMessage;

final class HttpBodyEncoder<T>
extends Encoder<Object, HttpMessage<T>> {
    final HttpMessage<T> message;
    final Encoder<?, ?> payloadEncoder;
    final long contentLength;
    final long offset;

    HttpBodyEncoder(HttpMessage<T> message, Encoder<?, ?> payloadEncoder, long contentLength, long offset) {
        this.message = message;
        this.payloadEncoder = payloadEncoder;
        this.contentLength = contentLength;
        this.offset = offset;
    }

    HttpBodyEncoder(HttpMessage<T> message, Encoder<?, ?> payloadEncoder, long contentLength) {
        this(message, payloadEncoder, contentLength, 0L);
    }

    public Encoder<Object, HttpMessage<T>> pull(OutputBuffer<?> output) {
        return HttpBodyEncoder.encode(output, this.message, this.payloadEncoder, this.contentLength, this.offset);
    }

    static <T> Encoder<Object, HttpMessage<T>> encode(OutputBuffer<?> output, HttpMessage<T> message, Encoder<?, ?> payloadEncoder, long contentLength, long offset) {
        int outputStart = output.index();
        int outputLimit = output.limit();
        int outputRemaining = outputLimit - outputStart;
        long inputRemaining = contentLength - offset;
        boolean outputPart = output.isPart();
        if (inputRemaining <= (long)outputRemaining) {
            output = output.limit(outputStart + (int)inputRemaining).isPart(false);
            payloadEncoder = payloadEncoder.pull(output);
            output = output.limit(outputLimit);
        } else {
            output = output.isPart(true);
            payloadEncoder = payloadEncoder.pull(output);
        }
        output = output.isPart(outputPart);
        offset += (long)(output.index() - outputStart);
        if (payloadEncoder.isDone()) {
            if (offset < contentLength) {
                return Encoder.error((Throwable)new EncoderException("buffer underflow"));
            }
            if (offset > contentLength) {
                return Encoder.error((Throwable)new EncoderException("buffer overflow"));
            }
            return Encoder.done(message);
        }
        if (payloadEncoder.isError()) {
            return payloadEncoder.asError();
        }
        if (output.isDone()) {
            return Encoder.error((Throwable)new EncoderException("truncated"));
        }
        if (output.isError()) {
            return Encoder.error((Throwable)output.trap());
        }
        return new HttpBodyEncoder<T>(message, payloadEncoder, contentLength, offset);
    }

    static <T> Encoder<Object, HttpMessage<T>> encode(OutputBuffer<?> output, HttpMessage<T> message, Encoder<?, ?> payloadEncoder, long contentLength) {
        return HttpBodyEncoder.encode(output, message, payloadEncoder, contentLength, 0L);
    }
}

