/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.Writer;
import swim.http.Http;
import swim.http.HttpPart;
import swim.http.HttpWriter;
import swim.util.Murmur3;

public final class HttpCharset
extends HttpPart
implements Debug {
    final String name;
    final float weight;
    private static int hashSeed;
    private static HttpCharset star;

    HttpCharset(String name, float weight) {
        this.name = name;
        this.weight = weight;
    }

    public boolean isStar() {
        return "*".equals(this.name);
    }

    public String name() {
        return this.name;
    }

    public float weight() {
        return this.weight;
    }

    public HttpCharset weight(float weight) {
        if (this.weight == weight) {
            return this;
        }
        return HttpCharset.create(this.name, weight);
    }

    @Override
    public Writer<?, ?> httpWriter(HttpWriter http) {
        return http.charsetWriter(this.name, this.weight);
    }

    @Override
    public Writer<?, ?> writeHttp(Output<?> output, HttpWriter http) {
        return http.writeCharset(output, this.name, this.weight);
    }

    public boolean matches(HttpCharset that) {
        if (this == that) {
            return true;
        }
        return this.name.equalsIgnoreCase(that.name);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof HttpCharset) {
            HttpCharset that = (HttpCharset)other;
            return this.name.equals(that.name) && this.weight == that.weight;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(HttpCharset.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.name.hashCode()), (int)Murmur3.hash((float)this.weight)));
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("HttpCharset").write(46).write("create").write(40).debug((Object)this.name);
        if (this.weight != 1.0f) {
            output = output.write(", ").debug((Object)Float.valueOf(this.weight));
        }
        output = output.write(41);
        return output;
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static HttpCharset star() {
        if (star == null) {
            star = new HttpCharset("*", 1.0f);
        }
        return star;
    }

    public static HttpCharset create(String name, float weight) {
        if (weight == 1.0f) {
            return HttpCharset.create(name);
        }
        return new HttpCharset(name, weight);
    }

    public static HttpCharset create(String name) {
        if ("*".equals(name)) {
            return HttpCharset.star();
        }
        return new HttpCharset(name, 1.0f);
    }

    public static HttpCharset parse(String string) {
        return Http.standardParser().parseCharsetString(string);
    }
}

