/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import java.nio.ByteBuffer;
import swim.codec.Binary;
import swim.codec.Debug;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.codec.Utf8;
import swim.http.Http;
import swim.http.HttpChunkEncoder;
import swim.http.HttpChunkHeader;
import swim.http.HttpWriter;
import swim.util.Murmur3;

public final class HttpChunk
implements Debug {
    final HttpChunkHeader header;
    final Encoder<?, ?> content;
    private static int hashSeed;
    private static HttpChunk last;

    public HttpChunk(HttpChunkHeader header, Encoder<?, ?> content) {
        this.header = header;
        this.content = content;
    }

    public boolean isEmpty() {
        return this.header.isEmpty();
    }

    public HttpChunkHeader header() {
        return this.header;
    }

    public Encoder<?, ?> content() {
        return this.content;
    }

    public Encoder<?, ?> httpEncoder(HttpWriter http) {
        if (this.header.isEmpty()) {
            return Utf8.encodedWriter(this.header.httpWriter(http));
        }
        return new HttpChunkEncoder(http, this.header, this.content);
    }

    public Encoder<?, ?> httpEncoder() {
        return this.httpEncoder(Http.standardWriter());
    }

    public Encoder<?, ?> encodeHttp(OutputBuffer<?> output, HttpWriter http) {
        if (this.header.isEmpty()) {
            return Utf8.writeEncoded(output, this.header.httpWriter(http));
        }
        return HttpChunkEncoder.encode(output, http, this.header, this.content);
    }

    public Encoder<?, ?> encodeHttp(OutputBuffer<?> output) {
        return this.encodeHttp(output, Http.standardWriter());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof HttpChunk) {
            HttpChunk that = (HttpChunk)other;
            return this.header.equals(that.header) && this.content.equals(that.content);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(HttpChunk.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.header.hashCode()), (int)this.content.hashCode()));
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("HttpChunk").write(46);
        output = this.header != HttpChunkHeader.sentinel() ? output.write("create").write(40).debug((Object)this.header).write(", ").debug(this.content).write(41) : output.write("last").write(40).write(41);
        return output;
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static HttpChunk last() {
        if (last == null) {
            last = new HttpChunk(HttpChunkHeader.sentinel(), Encoder.done());
        }
        return last;
    }

    public static HttpChunk create(int length, Encoder<?, ?> content) {
        HttpChunkHeader header = HttpChunkHeader.create(length);
        return new HttpChunk(header, content);
    }

    public static HttpChunk create(ByteBuffer data) {
        HttpChunkHeader header = HttpChunkHeader.create(data.remaining());
        return new HttpChunk(header, (Encoder<?, ?>)Binary.byteBufferWriter((ByteBuffer)data));
    }

    public static HttpChunk create(String text) {
        Output output = Utf8.encodedOutput((Output)Binary.byteBufferOutput((int)text.length()));
        output = output.write(text);
        ByteBuffer data = (ByteBuffer)output.bind();
        HttpChunkHeader header = HttpChunkHeader.create(data.remaining());
        return new HttpChunk(header, (Encoder<?, ?>)Binary.byteBufferWriter((ByteBuffer)data));
    }
}

