/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.collections.FingerTrieSeq;
import swim.http.Http;
import swim.http.HttpChunkTrailer;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.util.Builder;

final class HttpChunkTrailerParser
extends Parser<HttpChunkTrailer> {
    final HttpParser http;
    final Parser<? extends HttpHeader> headerParser;
    final Builder<HttpHeader, FingerTrieSeq<HttpHeader>> headers;
    final int step;

    HttpChunkTrailerParser(HttpParser http, Parser<? extends HttpHeader> headerParser, Builder<HttpHeader, FingerTrieSeq<HttpHeader>> headers, int step) {
        this.http = http;
        this.headerParser = headerParser;
        this.headers = headers;
        this.step = step;
    }

    HttpChunkTrailerParser(HttpParser http) {
        this(http, null, null, 1);
    }

    public Parser<HttpChunkTrailer> feed(Input input) {
        return HttpChunkTrailerParser.parse(input, this.http, this.headerParser, this.headers, this.step);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Parser<HttpChunkTrailer> parse(Input input, HttpParser http, Parser<? extends HttpHeader> headerParser32222, Builder<HttpHeader, FingerTrieSeq<HttpHeader>> headers, int step) {
        void headerParser32222;
        int c;
        block23: {
            c = 0;
            while (true) {
                if (step == 1) {
                    if (input.isCont()) {
                        c = input.head();
                        if (Http.isTokenChar(c)) {
                            step = 2;
                        } else {
                            if (Http.isSpace(c)) {
                                return Parser.error((Diagnostic)Diagnostic.message((String)"unsupported header line extension", (Input)input));
                            }
                            if (c != 13) return Parser.error((Diagnostic)Diagnostic.expected((String)"chunk trailer", (Input)input));
                            input = input.step();
                            step = 5;
                        }
                    } else if (input.isDone()) {
                        return Parser.error((Diagnostic)Diagnostic.expected((String)"chunk trailer", (Input)input));
                    }
                }
                if (step == 2) {
                    void headerParser32222;
                    if (headerParser32222 == null) {
                        Parser<HttpHeader> headerParser32222 = http.parseHeader(input);
                    } else {
                        void headerParser32222;
                        Parser headerParser32222 = headerParser32222.feed(input);
                    }
                    if (headerParser32222.isDone()) {
                        step = 3;
                    } else if (headerParser32222.isError()) {
                        return headerParser32222.asError();
                    }
                }
                if (step == 3) {
                    if (input.isCont()) {
                        c = input.head();
                        if (c != 13) return Parser.error((Diagnostic)Diagnostic.expected((String)"carriage return", (Input)input));
                        input = input.step();
                        step = 4;
                    } else if (input.isDone()) {
                        return Parser.error((Diagnostic)Diagnostic.expected((String)"carriage return", (Input)input));
                    }
                }
                if (step != 4) break block23;
                if (!input.isCont()) break;
                c = input.head();
                if (c != 10) return Parser.error((Diagnostic)Diagnostic.expected((String)"line feed", (Input)input));
                input = input.step();
                if (headers == null) {
                    headers = FingerTrieSeq.builder();
                }
                headers.add((Object)((HttpHeader)headerParser32222.bind()));
                Object headerParser32222 = null;
                step = 1;
            }
            if (input.isDone()) {
                return Parser.error((Diagnostic)Diagnostic.expected((String)"line feed", (Input)input));
            }
        }
        if (step == 5) {
            if (input.isCont()) {
                c = input.head();
                if (c != 10) return Parser.error((Diagnostic)Diagnostic.expected((String)"line feed", (Input)input));
                input = input.step();
                if (headers != null) return Parser.done((Object)http.chunkTrailer((FingerTrieSeq<HttpHeader>)((FingerTrieSeq)headers.bind())));
                return Parser.done((Object)http.chunkTrailer((FingerTrieSeq<HttpHeader>)FingerTrieSeq.empty()));
            }
            if (input.isDone()) {
                return Parser.error((Diagnostic)Diagnostic.expected((String)"line feed", (Input)input));
            }
        }
        if (!input.isError()) return new HttpChunkTrailerParser(http, (Parser<? extends HttpHeader>)headerParser32222, (Builder<HttpHeader, FingerTrieSeq<HttpHeader>>)headers, step);
        return Parser.error((Throwable)input.trap());
    }

    static Parser<HttpChunkTrailer> parse(Input input, HttpParser http) {
        return HttpChunkTrailerParser.parse(input, http, null, null, 1);
    }
}

