/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import swim.codec.Binary;
import swim.codec.Debug;
import swim.codec.Decoder;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.InputBuffer;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.collections.FingerTrieSeq;
import swim.http.Http;
import swim.http.HttpHeader;
import swim.http.HttpMessage;
import swim.http.HttpPayload;
import swim.http.HttpWriter;
import swim.http.MediaType;
import swim.http.TransferCoding;
import swim.http.header.ContentTypeHeader;
import swim.http.header.TransferEncodingHeader;
import swim.util.Murmur3;

public final class HttpChunked<T>
extends HttpPayload<T>
implements Debug {
    final T payloadValue;
    final Encoder<?, ?> payloadEncoder;
    final MediaType mediaType;
    private static int hashSeed;

    HttpChunked(T payloadValue, Encoder<?, ?> payloadEncoder, MediaType mediaType) {
        this.payloadValue = payloadValue;
        this.payloadEncoder = payloadEncoder;
        this.mediaType = mediaType;
    }

    @Override
    public boolean isDefined() {
        return this.payloadValue != null;
    }

    @Override
    public T get() {
        return this.payloadValue;
    }

    public Encoder<?, ?> payloadEncoder() {
        return this.payloadEncoder;
    }

    @Override
    public MediaType mediaType() {
        return this.mediaType;
    }

    @Override
    public FingerTrieSeq<TransferCoding> transferCodings() {
        return TransferEncodingHeader.chunked().codings();
    }

    @Override
    public FingerTrieSeq<HttpHeader> headers() {
        FingerTrieSeq headers = FingerTrieSeq.empty();
        if (this.mediaType != null) {
            headers = headers.appended((Object)ContentTypeHeader.create(this.mediaType));
        }
        headers = headers.appended((Object)TransferEncodingHeader.chunked());
        return headers;
    }

    @Override
    public <T2> Encoder<?, HttpMessage<T2>> httpEncoder(HttpMessage<T2> message, HttpWriter http) {
        return http.chunkedEncoder(message, this.payloadEncoder);
    }

    @Override
    public <T2> Encoder<?, HttpMessage<T2>> encodeHttp(OutputBuffer<?> output, HttpMessage<T2> message, HttpWriter http) {
        return http.encodeChunked(output, message, this.payloadEncoder);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof HttpChunked) {
            HttpChunked that = (HttpChunked)other;
            return (this.payloadValue == null ? that.payloadValue == null : this.payloadValue.equals(that.payloadValue)) && (this.mediaType == null ? that.mediaType == null : this.mediaType.equals(that.mediaType));
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(HttpChunked.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash(this.payloadValue)), (int)Murmur3.hash((Object)this.mediaType)));
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("HttpChunked").write(46).write("create").write(40);
        if (this.payloadValue != null) {
            output.debug(this.payloadValue).write(", ");
        }
        output.debug(this.payloadEncoder);
        if (this.mediaType != null) {
            output = output.write(", ").debug((Object)this.mediaType);
        }
        output = output.write(41);
        return output;
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static <T> HttpChunked<T> create(T payloadValue, Encoder<?, T> payloadEncoder, MediaType mediaType) {
        return new HttpChunked<T>(payloadValue, payloadEncoder, mediaType);
    }

    public static <T> HttpChunked<T> create(T payloadValue, Encoder<?, T> payloadEncoder) {
        return new HttpChunked<T>(payloadValue, payloadEncoder, null);
    }

    public static <T> HttpChunked<T> create(Encoder<?, T> payloadEncoder, MediaType mediaType) {
        return new HttpChunked<Object>(null, payloadEncoder, mediaType);
    }

    public static <T> HttpChunked<T> create(Encoder<?, T> payloadEncoder) {
        return new HttpChunked<Object>(null, payloadEncoder, null);
    }

    public static <T> HttpChunked<T> fromFile(String path, MediaType mediaType) throws IOException {
        FileChannel channel = FileChannel.open(Paths.get(path, new String[0]), StandardOpenOption.READ);
        return new HttpChunked<Object>(null, Binary.channelEncoder((ReadableByteChannel)channel), mediaType);
    }

    public static <T> HttpChunked<T> fromFile(String path) throws IOException {
        return HttpChunked.fromFile(path, MediaType.forPath(path));
    }

    public static <T> Decoder<HttpMessage<T>> httpDecoder(HttpMessage<?> message, Decoder<T> payloadDecoder) {
        return Http.standardParser().chunkedDecoder(message, payloadDecoder);
    }

    public static <T> Decoder<HttpMessage<T>> decodeHttp(InputBuffer input, HttpMessage<?> message, Decoder<T> payloadDecoder) {
        return Http.standardParser().decodeChunked(input, message, payloadDecoder);
    }
}

